/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import java.util.AbstractSet;
import java.util.Iterator;
import org.checkerframework.checker.index.qual.NonNegative;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import pl.topteam.common.collect.Edge;

@NullMarked
@Immutable(containerOf={"N"})
@Beta
final class EdgeSet<N>
extends AbstractSet<Edge<N>> {
    private final ImmutableMap<N, N> parents;

    public EdgeSet(ImmutableMap<N, N> parents) {
        this.parents = (ImmutableMap)Preconditions.checkNotNull(parents);
    }

    @Override
    public Iterator<Edge<N>> iterator() {
        return this.parents.entrySet().stream().map(entry -> new Edge(entry.getValue(), entry.getKey())).iterator();
    }

    @Override
    public @NonNegative int size() {
        return this.parents.size();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        if (!(object instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)object;
        return edge.parent().equals(this.parents.get(edge.child()));
    }
}

