/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.collect.DiscreteDomain;
import com.google.errorprone.annotations.Immutable;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import javax.annotation.CheckForNull;

public final class ExtraDiscreteDomains {
    private ExtraDiscreteDomains() {
    }

    public static DiscreteDomain<Character> characters() {
        return CharacterDomain.INSTANCE;
    }

    public static DiscreteDomain<LocalDate> localDates() {
        return LocalDateDomain.INSTANCE;
    }

    public static DiscreteDomain<YearMonth> yearMonths() {
        return YearMonthDomain.INSTANCE;
    }

    public static DiscreteDomain<Year> years() {
        return YearDomain.INSTANCE;
    }

    @Immutable
    private static final class CharacterDomain
    extends DiscreteDomain<Character> {
        private static final CharacterDomain INSTANCE = new CharacterDomain();
        private static final char MIN = '\u0000';
        private static final char MAX = '\uffff';

        private CharacterDomain() {
        }

        @CheckForNull
        public Character next(Character value) {
            char c = value.charValue();
            return c == '\uffff' ? null : Character.valueOf((char)(c + '\u0001'));
        }

        @CheckForNull
        public Character previous(Character value) {
            char c = value.charValue();
            return c == '\u0000' ? null : Character.valueOf((char)(c - '\u0001'));
        }

        public long distance(Character start, Character end) {
            return end.charValue() - start.charValue();
        }

        public Character minValue() {
            return Character.valueOf('\u0000');
        }

        public Character maxValue() {
            return Character.valueOf('\uffff');
        }
    }

    @Immutable
    private static final class LocalDateDomain
    extends DiscreteDomain<LocalDate> {
        private static final LocalDateDomain INSTANCE = new LocalDateDomain();
        private static final LocalDate MIN = LocalDate.MIN;
        private static final LocalDate MAX = LocalDate.MAX;

        private LocalDateDomain() {
        }

        @CheckForNull
        public LocalDate next(LocalDate value) {
            return value.equals(MAX) ? null : value.plusDays(1L);
        }

        @CheckForNull
        public LocalDate previous(LocalDate value) {
            return value.equals(MIN) ? null : value.minusDays(1L);
        }

        public long distance(LocalDate start, LocalDate end) {
            return ChronoUnit.DAYS.between(start, end);
        }

        public LocalDate minValue() {
            return MIN;
        }

        public LocalDate maxValue() {
            return MAX;
        }
    }

    @Immutable
    private static final class YearMonthDomain
    extends DiscreteDomain<YearMonth> {
        private static final YearMonthDomain INSTANCE = new YearMonthDomain();
        private static final YearMonth MIN = YearMonth.from(LocalDate.MIN);
        private static final YearMonth MAX = YearMonth.from(LocalDate.MAX);

        private YearMonthDomain() {
        }

        @CheckForNull
        public YearMonth next(YearMonth value) {
            return value.equals(MAX) ? null : value.plusMonths(1L);
        }

        @CheckForNull
        public YearMonth previous(YearMonth value) {
            return value.equals(MIN) ? null : value.minusMonths(1L);
        }

        public long distance(YearMonth start, YearMonth end) {
            return ChronoUnit.MONTHS.between(start, end);
        }

        public YearMonth minValue() {
            return MIN;
        }

        public YearMonth maxValue() {
            return MAX;
        }
    }

    @Immutable
    private static final class YearDomain
    extends DiscreteDomain<Year> {
        private static final YearDomain INSTANCE = new YearDomain();
        private static final Year MIN = Year.of(-999999999);
        private static final Year MAX = Year.of(999999999);

        private YearDomain() {
        }

        @CheckForNull
        public Year next(Year value) {
            return value.equals(MAX) ? null : value.plusYears(1L);
        }

        @CheckForNull
        public Year previous(Year value) {
            return value.equals(MIN) ? null : value.minusYears(1L);
        }

        public long distance(Year start, Year end) {
            return ChronoUnit.YEARS.between(start, end);
        }

        public Year minValue() {
            return MIN;
        }

        public Year maxValue() {
            return MAX;
        }
    }
}

