/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.NullMarked;
import pl.topteam.common.collect.ExtraIterators;

@NullMarked
public final class ExtraIterables {
    private ExtraIterables() {
    }

    public static <T> Iterable<T> commonPrefix(Iterable<? extends T> i1, Iterable<? extends T> i2) {
        Preconditions.checkNotNull(i1);
        Preconditions.checkNotNull(i2);
        return ExtraIterables.commonPrefix(ImmutableList.of(i1, i2));
    }

    public static <T> Iterable<T> commonPrefix(Collection<? extends Iterable<? extends T>> c) {
        Preconditions.checkNotNull(c);
        if (Iterables.isEmpty(c)) {
            return ImmutableList.of();
        }
        Iterable first = (Iterable)FluentIterable.from(c).first().get();
        ImmutableList rest = FluentIterable.from(c).skip(1).transform(Iterable::iterator).toList();
        return ExtraIterables.limit(first, arg_0 -> ExtraIterables.lambda$commonPrefix$1((Iterable)rest, arg_0));
    }

    public static <T> T getUnique(Iterable<? extends T> iterable, T defaultValue) {
        Preconditions.checkNotNull(iterable);
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return defaultValue;
        }
        T first = iterator.next();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (Objects.equals(next, first)) continue;
            return defaultValue;
        }
        return first;
    }

    public static <T> T getFirst(Iterable<? extends T> iterable) {
        Preconditions.checkNotNull(iterable);
        return iterable.iterator().next();
    }

    public static <T> T getLast(Iterable<? extends T> iterable) {
        Preconditions.checkNotNull(iterable);
        return (T)Iterables.getLast(iterable);
    }

    @Deprecated
    private static <T> Iterable<T> iterate(T seed, UnaryOperator<T> next) {
        throw new UnsupportedOperationException();
    }

    public static <T> Iterable<T> iterate(T seed, Predicate<? super T> hasNext, UnaryOperator<T> next) {
        Preconditions.checkNotNull(hasNext);
        Preconditions.checkNotNull(next);
        return () -> ExtraIterators.iterate(seed, hasNext, next);
    }

    public static <T> Iterable<T> limit(Iterable<? extends T> iterable, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(predicate);
        return () -> ExtraIterators.limit(iterable.iterator(), predicate);
    }

    public static <T> Iterable<T> collapseDuplicates(Iterable<? extends T> iterable, Equivalence<? super T> equivalence) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(equivalence);
        return () -> ExtraIterators.collapseDuplicates(iterable.iterator(), equivalence);
    }

    public static <T> Iterable<T> collapseDuplicates(Iterable<? extends T> iterable, Comparator<? super T> comparator) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(comparator);
        return () -> ExtraIterators.collapseDuplicates(iterable.iterator(), comparator);
    }

    private static /* synthetic */ boolean lambda$commonPrefix$1(Iterable rest, Object head) {
        if (!Iterables.all((Iterable)rest, Iterator::hasNext)) {
            return false;
        }
        Iterable values = Iterables.transform((Iterable)rest, Iterator::next);
        return Iterables.all((Iterable)values, value -> Objects.equals(value, head));
    }
}

