/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ExtraIterators {
    private ExtraIterators() {
    }

    @Deprecated
    private static <T> Iterator<T> iterate(T seed, UnaryOperator<T> next) {
        throw new UnsupportedOperationException();
    }

    public static <T> Iterator<T> iterate(T seed, Predicate<? super T> hasNext, UnaryOperator<T> next) {
        Preconditions.checkNotNull(hasNext);
        Preconditions.checkNotNull(next);
        return ExtraIterators.limit(Stream.iterate(seed, next).iterator(), hasNext);
    }

    public static <T> UnmodifiableIterator<T> limit(final Iterator<? extends T> iterator, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        return new AbstractIterator<T>(){

            protected @Nullable T computeNext() {
                Object result;
                if (iterator.hasNext() && predicate.test(result = iterator.next())) {
                    return result;
                }
                return this.endOfData();
            }
        };
    }

    public static <T> UnmodifiableIterator<T> collapseDuplicates(Iterator<? extends T> iterator, Equivalence<? super T> equivalence) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(equivalence);
        return ExtraIterators.collapseDuplicatesInternal(iterator, (previous, next) -> equivalence.equivalent(previous, next));
    }

    public static <T> UnmodifiableIterator<T> collapseDuplicates(Iterator<? extends T> iterator, Comparator<? super T> comparator) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(comparator);
        return ExtraIterators.collapseDuplicatesInternal(iterator, (previous, next) -> comparator.compare(previous, next) == 0);
    }

    private static <T> UnmodifiableIterator<T> collapseDuplicatesInternal(final Iterator<? extends T> iterator, final BiPredicate<? super T, ? super T> equality) {
        assert (iterator != null);
        assert (equality != null);
        return new AbstractIterator<T>(){
            boolean hasPrevious;
            T previous;

            protected @Nullable T computeNext() {
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (this.hasPrevious && equality.test(this.previous, next)) continue;
                    this.hasPrevious = true;
                    this.previous = next;
                    return next;
                }
                return this.endOfData();
            }
        };
    }
}

