/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import pl.topteam.common.collect.ExtraIterables;

@NullMarked
public final class ExtraLists {
    private ExtraLists() {
    }

    public static <E> List<E> commonPrefix(List<? extends E> l1, List<? extends E> l2) {
        Preconditions.checkNotNull(l1);
        Preconditions.checkNotNull(l2);
        return ExtraLists.commonPrefix(ImmutableList.of(l1, l2));
    }

    public static <E> List<E> commonPrefix(Collection<? extends List<? extends E>> ls) {
        Preconditions.checkNotNull(ls);
        return ls.isEmpty() ? ImmutableList.of() : ImmutableList.copyOf(ExtraIterables.commonPrefix(ls));
    }

    public static <E> List<E> commonSuffix(List<? extends E> l1, List<? extends E> l2) {
        Preconditions.checkNotNull(l1);
        Preconditions.checkNotNull(l2);
        return ExtraLists.commonSuffix(ImmutableList.of(l1, l2));
    }

    public static <E> List<E> commonSuffix(Collection<? extends List<? extends E>> ls) {
        Preconditions.checkNotNull(ls);
        Collection reversed = Collections2.transform(ls, Lists::reverse);
        return Lists.reverse(ExtraLists.commonPrefix(reversed));
    }
}

