/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;

final class MaximumBipartiteMatching {
    private MaximumBipartiteMatching() {
    }

    public static <U, V> int of(Set<U> source, Set<V> target, BiPredicate<U, V> matcher) {
        Preconditions.checkNotNull(source);
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(matcher);
        HashMultimap g = HashMultimap.create();
        for (U s : source) {
            for (V t : target) {
                if (!matcher.test(s, t)) continue;
                g.put(s, t);
            }
        }
        return MaximumBipartiteMatching.kuhn(g).size();
    }

    private static <U, V> Map<V, U> kuhn(SetMultimap<U, V> g) {
        HashMap mt = new HashMap();
        for (Object v : g.keySet()) {
            HashSet used = new HashSet();
            MaximumBipartiteMatching.tryKuhn(g, mt, used, v);
        }
        return mt;
    }

    private static <U, V> boolean tryKuhn(SetMultimap<U, V> g, Map<V, U> mt, Set<U> used, U v) {
        if (used.contains(v)) {
            return false;
        }
        used.add(v);
        for (Object to : g.get(v)) {
            if (mt.containsKey(to) && !MaximumBipartiteMatching.tryKuhn(g, mt, used, mt.get(to))) continue;
            mt.put(to, v);
            return true;
        }
        return false;
    }
}

