/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.temporal;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;

public enum ExtraChronoUnit implements TemporalUnit
{
    LEGAL_DAYS(ChronoUnit.DAYS),
    LEGAL_MONTHS(ChronoUnit.MONTHS),
    LEGAL_YEARS(ChronoUnit.YEARS);

    private final ChronoUnit baseUnit;

    private ExtraChronoUnit(ChronoUnit baseUnit) {
        this.baseUnit = (ChronoUnit)Preconditions.checkNotNull((Object)baseUnit);
    }

    @Override
    public Duration getDuration() {
        return this.baseUnit.getDuration();
    }

    @Override
    public boolean isDurationEstimated() {
        return this.baseUnit.isDurationEstimated();
    }

    @Override
    public boolean isDateBased() {
        return this.baseUnit.isDateBased();
    }

    @Override
    public boolean isTimeBased() {
        return this.baseUnit.isTimeBased();
    }

    @Override
    public <R extends Temporal> R addTo(R temporal, long amount) {
        return this.baseUnit.addTo(temporal, amount);
    }

    @Override
    public long between(Temporal temporal1Inclusive, Temporal temporal2Exclusive) {
        long amount = this.baseUnit.between(temporal1Inclusive, temporal2Exclusive);
        return temporal1Inclusive.plus(amount + 1L, this.baseUnit).equals(temporal2Exclusive) ? amount + 1L : amount;
    }
}

