/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.text;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.regex.Pattern;
import org.checkerframework.checker.regex.qual.Regex;

final class RomanFormat
extends NumberFormat {
    private static final long serialVersionUID = 1L;
    private static final @Regex Pattern wzorzec = Pattern.compile("M{0,4}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})");
    private static final long[] liczby = new long[]{1L, 4L, 5L, 9L, 10L, 40L, 50L, 90L, 100L, 400L, 500L, 900L, 1000L};
    private static final String[] litery = new String[]{"I", "IV", "V", "IX", "X", "XL", "L", "XC", "C", "CD", "D", "CM", "M"};

    RomanFormat() {
    }

    @Override
    @Deprecated
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        Preconditions.checkArgument((number > 0L ? 1 : 0) != 0, (Object)"Liczba musi by\u0107 wi\u0119ksza od 0");
        Preconditions.checkArgument((number < 4000L ? 1 : 0) != 0, (Object)"Liczba musi by\u0107 mniejsza od 4000");
        int i = liczby.length - 1;
        assert (i >= 0) : "@AssumeAssertion(index)";
        assert (i < liczby.length) : "@AssumeAssertion(index)";
        assert (i < litery.length) : "@AssumeAssertion(index)";
        while (number > 0L) {
            while (liczby[i] > number) {
                assert (--i >= 0) : "@AssumeAssertion(index)";
                assert (i < liczby.length) : "@AssumeAssertion(index)";
                assert (i < litery.length) : "@AssumeAssertion(index)";
            }
            toAppendTo.append(litery[i]);
            number -= liczby[i];
        }
        return toAppendTo;
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        Preconditions.checkArgument((!source.isEmpty() ? 1 : 0) != 0, (Object)"Tekst nie mo\u017ce by\u0107 pusty");
        if (!wzorzec.matcher(source).matches()) {
            return Double.NaN;
        }
        long number = 0L;
        int i = litery.length - 1;
        assert (i >= 0) : "@AssumeAssertion(index)";
        assert (i < liczby.length) : "@AssumeAssertion(index)";
        assert (i < litery.length) : "@AssumeAssertion(index)";
        while (parsePosition.getIndex() < source.length()) {
            while (!source.startsWith(litery[i], parsePosition.getIndex())) {
                assert (--i >= 0) : "@AssumeAssertion(index)";
                assert (i < liczby.length) : "@AssumeAssertion(index)";
                assert (i < litery.length) : "@AssumeAssertion(index)";
            }
            parsePosition.setIndex(parsePosition.getIndex() + litery[i].length());
            number += liczby[i];
        }
        return number;
    }

    static {
        Verify.verify((liczby.length == litery.length ? 1 : 0) != 0);
    }
}

