/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.primitives.Chars;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import pl.topteam.common.collect.ExtraDiscreteDomains;

public final class LookupComparator
implements Comparator<Character>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final char[] lookup;

    public LookupComparator(@NonNull Comparator<? super Character> comparator) {
        this.lookup = LookupComparator.lookup((Comparator)Preconditions.checkNotNull(comparator));
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        if (object instanceof LookupComparator) {
            LookupComparator that = (LookupComparator)object;
            return Arrays.equals(this.lookup, that.lookup);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.lookup);
    }

    @Override
    public int compare(Character c1, Character c2) {
        assert (c1.charValue() < this.lookup.length) : "@AssumeAssertion(index)";
        assert (c2.charValue() < this.lookup.length) : "@AssumeAssertion(index)";
        return Character.compare(this.lookup[c1.charValue()], this.lookup[c2.charValue()]);
    }

    private static char[] lookup(Comparator<? super Character> comparator) {
        char[] ordering = LookupComparator.ordering(comparator);
        char[] lookup = new char[ordering.length];
        int i = 0;
        while (i < ordering.length) {
            int j;
            for (j = i; j < ordering.length && comparator.compare(Character.valueOf(ordering[i]), Character.valueOf(ordering[j])) == 0; ++j) {
                lookup[ordering[j]] = Chars.checkedCast((long)i);
            }
            i = j;
        }
        return lookup;
    }

    private static char[] ordering(Comparator<? super Character> comparator) {
        ContiguousSet characters = ContiguousSet.create((Range)Range.all(), ExtraDiscreteDomains.characters());
        return Chars.toArray((Collection)ImmutableList.sortedCopyOf(comparator, (Iterable)characters));
    }
}

