/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.przekazy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import java.util.ArrayList;
import org.springframework.stereotype.Component;
import pl.topteam.common.format.kontakty.EmailPrinter;
import pl.topteam.common.format.kontakty.TelefonPrinter;
import pl.topteam.common.util.ExtraLocales;
import pl.topteam.jerzyk.konwertery.przekazy.Konwerter;
import pl.topteam.jerzyk.model.przekazy.Paczka;
import pl.topteam.jerzyk.model.przekazy.Zlecenie;
import pl.topteam.jerzyk.model.przekazy.csv.PrzekazPocztowyCSVPaczka;
import pl.topteam.jerzyk.model.przekazy.csv.PrzekazPocztowyCSVZlecenie;
import pl.topteam.jerzyk.model.przekazy.csv.typy.RodzajAdresu;
import pl.topteam.jerzyk.model.przekazy.csv.typy.RodzajPrzekazu;
import pl.topteam.jerzyk.model.przekazy.csv.typy.Usluga;

@Component
public class PrzekazPocztowyCSVKonwerter
implements Konwerter<PrzekazPocztowyCSVPaczka> {
    private static final EmailPrinter EMAIL = new EmailPrinter();
    private static final TelefonPrinter TELEFON = new TelefonPrinter();
    private final Usluga usluga;
    private final RodzajPrzekazu rodzajPrzekazu;

    public PrzekazPocztowyCSVKonwerter(Usluga usluga, RodzajPrzekazu rodzajPrzekazu) {
        this.usluga = (Usluga)((Object)Preconditions.checkNotNull((Object)((Object)usluga)));
        this.rodzajPrzekazu = (RodzajPrzekazu)((Object)Preconditions.checkNotNull((Object)((Object)rodzajPrzekazu)));
    }

    @Override
    public PrzekazPocztowyCSVPaczka konwertuj(Paczka paczka) {
        PrzekazPocztowyCSVPaczka _paczka = new PrzekazPocztowyCSVPaczka();
        _paczka.setUsluga(this.usluga);
        Verify.verifyNotNull((Object)paczka.getNadawca());
        _paczka.setNazwaSkroconaNadawcy(paczka.getNadawca().getNazwa());
        _paczka.setEmailNadawcy(paczka.getNadawca().getEmail() != null ? Strings.emptyToNull((String)EMAIL.print(paczka.getNadawca().getEmail(), ExtraLocales.PL)) : null);
        _paczka.setTelefonNadawcy(paczka.getNadawca().getTelefon() != null ? Strings.emptyToNull((String)TELEFON.print(paczka.getNadawca().getTelefon(), ExtraLocales.PL)) : null);
        ArrayList<PrzekazPocztowyCSVZlecenie> _zlecenia = new ArrayList<PrzekazPocztowyCSVZlecenie>();
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            PrzekazPocztowyCSVZlecenie _zlecenie = new PrzekazPocztowyCSVZlecenie();
            _zlecenie.setRodzajPrzekazu(this.rodzajPrzekazu);
            _zlecenie.setWartosc(zlecenie.getKwota());
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            _zlecenie.setNazwaAdresata(zlecenie.getOdbiorca().getNazwa());
            if (zlecenie.getOdbiorca().getAdres() != null) {
                _zlecenie.setRodzajAdresuAdresata(RodzajAdresu.ADRES_STANDARDOWY);
                _zlecenie.setKodPocztowyAdresata(zlecenie.getOdbiorca().getAdres().getKod().replace("-", ""));
                _zlecenie.setMiejscowoscAdresata(zlecenie.getOdbiorca().getAdres().getMiejscowosc());
                _zlecenie.setUlicaAdresata(zlecenie.getOdbiorca().getAdres().getUlica());
                _zlecenie.setNumerDomuAdresata(zlecenie.getOdbiorca().getAdres().getBudynek());
                _zlecenie.setNumerLokaluAdresata(zlecenie.getOdbiorca().getAdres().getLokal());
            } else {
                _zlecenie.setRodzajAdresuAdresata(RodzajAdresu.BRAK_ADRESU);
            }
            _zlecenie.setEmailAdresata(zlecenie.getOdbiorca().getEmail() != null ? Strings.emptyToNull((String)EMAIL.print(zlecenie.getOdbiorca().getEmail(), ExtraLocales.PL)) : null);
            _zlecenie.setTelefonAdresata(zlecenie.getOdbiorca().getTelefon() != null ? Strings.emptyToNull((String)TELEFON.print(zlecenie.getOdbiorca().getTelefon(), ExtraLocales.PL)) : null);
            _zlecenia.add(_zlecenie);
        }
        _paczka.setZlecenia(_zlecenia);
        return _paczka;
    }
}

