/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.przekazy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Component;
import pl.pp.iwd.pe.v1.Atrybut;
import pl.pp.iwd.pe.v1.Nadawca;
import pl.pp.iwd.pe.v1.Przesylka;
import pl.pp.iwd.pe.v1.Zbior;
import pl.topteam.common.format.kontakty.EmailPrinter;
import pl.topteam.common.format.kontakty.TelefonPrinter;
import pl.topteam.common.util.ExtraLocales;
import pl.topteam.jerzyk.konwertery.przekazy.Konwerter;
import pl.topteam.jerzyk.model.przekazy.Paczka;
import pl.topteam.jerzyk.model.przekazy.Zlecenie;
import pl.topteam.jerzyk.model.przekazy.xml.typy.Strefa;
import pl.topteam.jerzyk.model.przekazy.xml.typy.Symbol;

@Component
public class PrzekazPocztowyXMLKonwerter
implements Konwerter<Nadawca> {
    private static final EmailPrinter EMAIL = new EmailPrinter();
    private static final TelefonPrinter TELEFON = new TelefonPrinter();
    private final Symbol symbol;
    private final Strefa strefa;

    public PrzekazPocztowyXMLKonwerter(Symbol symbol, Strefa strefa) {
        this.symbol = (Symbol)((Object)Preconditions.checkNotNull((Object)((Object)symbol)));
        this.strefa = (Strefa)((Object)Preconditions.checkNotNull((Object)((Object)strefa)));
    }

    @Override
    public Nadawca konwertuj(Paczka paczka) {
        Nadawca nadawca = new Nadawca();
        Verify.verifyNotNull((Object)paczka.getNadawca());
        nadawca.setNazwa(paczka.getNadawca().getNazwa());
        nadawca.setNazwaSkrocona(paczka.getNadawca().getNazwa());
        Verify.verifyNotNull((Object)paczka.getNadawca().getAdres());
        nadawca.setUlica(paczka.getNadawca().getAdres().getUlica());
        nadawca.setDom(paczka.getNadawca().getAdres().getBudynek());
        nadawca.setLokal(paczka.getNadawca().getAdres().getLokal());
        nadawca.setMiejscowosc(paczka.getNadawca().getAdres().getMiejscowosc());
        nadawca.setKod(paczka.getNadawca().getAdres().getKod().replace("-", ""));
        nadawca.setNumerTelefonu(paczka.getNadawca().getTelefon() != null ? Strings.emptyToNull((String)TELEFON.print(paczka.getNadawca().getTelefon(), ExtraLocales.PL)) : null);
        nadawca.setEmail(paczka.getNadawca().getEmail() != null ? Strings.emptyToNull((String)EMAIL.print(paczka.getNadawca().getEmail(), ExtraLocales.PL)) : null);
        nadawca.setGuid(paczka.getNadawca().getIdentyfikator());
        Zbior zbior = new Zbior();
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            Przesylka _zlecenie = new Przesylka();
            List<Atrybut> atrybuty = _zlecenie.getAtrybut();
            PrzekazPocztowyXMLKonwerter.dodajAtrybut(atrybuty, Atrybut.TypAtrybutu.BRAK, Atrybut.NazwaAtrybutu.SYMBOL, this.symbol.getWartosc());
            Verify.verifyNotNull((Object)zlecenie.getKwota());
            PrzekazPocztowyXMLKonwerter.dodajAtrybut(atrybuty, Atrybut.TypAtrybutu.BRAK, Atrybut.NazwaAtrybutu.WARTOSC, zlecenie.getKwota().toPlainString());
            PrzekazPocztowyXMLKonwerter.dodajAtrybut(atrybuty, Atrybut.TypAtrybutu.BRAK, Atrybut.NazwaAtrybutu.STREFA, this.strefa.getWartosc());
            PrzekazPocztowyXMLKonwerter.dodajAtrybut(atrybuty, Atrybut.TypAtrybutu.BRAK, Atrybut.NazwaAtrybutu.WERSJA, "1");
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca().getAdres());
            PrzekazPocztowyXMLKonwerter.dodajAtrybut(atrybuty, Atrybut.TypAtrybutu.ADRESAT, Atrybut.NazwaAtrybutu.ULICA, zlecenie.getOdbiorca().getAdres().getUlica());
            PrzekazPocztowyXMLKonwerter.dodajAtrybut(atrybuty, Atrybut.TypAtrybutu.ADRESAT, Atrybut.NazwaAtrybutu.DOM, zlecenie.getOdbiorca().getAdres().getBudynek());
            PrzekazPocztowyXMLKonwerter.dodajAtrybut(atrybuty, Atrybut.TypAtrybutu.ADRESAT, Atrybut.NazwaAtrybutu.LOKAL, zlecenie.getOdbiorca().getAdres().getLokal());
            PrzekazPocztowyXMLKonwerter.dodajAtrybut(atrybuty, Atrybut.TypAtrybutu.ADRESAT, Atrybut.NazwaAtrybutu.MIEJSCOWOSC, zlecenie.getOdbiorca().getAdres().getMiejscowosc());
            PrzekazPocztowyXMLKonwerter.dodajAtrybut(atrybuty, Atrybut.TypAtrybutu.ADRESAT, Atrybut.NazwaAtrybutu.KOD, zlecenie.getOdbiorca().getAdres().getKod().replace("-", ""));
            PrzekazPocztowyXMLKonwerter.dodajAtrybut(atrybuty, Atrybut.TypAtrybutu.ADRESAT, Atrybut.NazwaAtrybutu.NUMER_TELEFONU, zlecenie.getOdbiorca().getTelefon() != null ? TELEFON.print(zlecenie.getOdbiorca().getTelefon(), ExtraLocales.PL) : null);
            PrzekazPocztowyXMLKonwerter.dodajAtrybut(atrybuty, Atrybut.TypAtrybutu.ADRESAT, Atrybut.NazwaAtrybutu.EMAIL, zlecenie.getOdbiorca().getEmail() != null ? EMAIL.print(zlecenie.getOdbiorca().getEmail(), ExtraLocales.PL) : null);
            zbior.getPrzesylka().add(_zlecenie);
        }
        nadawca.setZbior(zbior);
        return nadawca;
    }

    private static void dodajAtrybut(List<Atrybut> atrybuty, Atrybut.TypAtrybutu typAtrybutu, Atrybut.NazwaAtrybutu nazwaAtrybutu, @Nullable String wartosc) {
        if (!Strings.isNullOrEmpty((String)wartosc)) {
            Atrybut atrybut = new Atrybut();
            atrybut.setTyp(typAtrybutu);
            atrybut.setNazwa(nazwaAtrybutu);
            atrybut.setWartosc(wartosc);
            atrybuty.add(atrybut);
        }
    }
}

