/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.przelewy;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import java.util.ArrayList;
import org.springframework.format.Printer;
import org.springframework.stereotype.Component;
import pl.topteam.common.format.kontakty.AdresPrinter;
import pl.topteam.common.model.kontakty.Adres;
import pl.topteam.common.util.ExtraLocales;
import pl.topteam.jerzyk.konwertery.przelewy.Konwerter;
import pl.topteam.jerzyk.model.przelewy.Paczka;
import pl.topteam.jerzyk.model.przelewy.Podmiot;
import pl.topteam.jerzyk.model.przelewy.Zlecenie;
import pl.topteam.jerzyk.model.przelewy.bzwbk.BZWBKPaczka;
import pl.topteam.jerzyk.model.przelewy.bzwbk.BZWBKZlecenie;

@Component
public class BZWBKKonwerter
implements Konwerter<BZWBKPaczka> {
    private static final Printer<Adres> ADRES = new AdresPrinter();

    @Override
    public BZWBKPaczka konwertuj(Paczka paczka) {
        BZWBKPaczka _paczka = new BZWBKPaczka();
        ArrayList<BZWBKZlecenie> _zlecenia = new ArrayList<BZWBKZlecenie>();
        int indeks = 1;
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            BZWBKZlecenie _zlecenie = new BZWBKZlecenie();
            _zlecenie.setNumerPaczki(1);
            _zlecenie.setNumerOperacji(indeks);
            Verify.verifyNotNull((Object)paczka.getNadawca());
            Verify.verifyNotNull((Object)paczka.getNadawca().getKonto());
            _zlecenie.setNumerOddzialuStronyWN(paczka.getNadawca().getKonto().value().substring(2, 10));
            _zlecenie.setNumerRachunkuStronyWN(paczka.getNadawca().getKonto().toIBAN());
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca().getKonto());
            _zlecenie.setNumerOddzialuStronyMA(zlecenie.getOdbiorca().getKonto().value().substring(2, 10));
            _zlecenie.setNumerRachunkuStronyMA(zlecenie.getOdbiorca().getKonto().toIBAN());
            _zlecenie.setTytulOperacji(zlecenie.getTytul());
            _zlecenie.setKwotaPrzelewu(zlecenie.getKwota());
            _zlecenie.setDaneAdresoweKlienta(this.daneAdresowe(zlecenie.getOdbiorca()));
            _zlecenie.setDataWykonaniaOperacji(zlecenie.getData());
            _zlecenia.add(_zlecenie);
            ++indeks;
        }
        _paczka.setZlecenia(_zlecenia);
        return _paczka;
    }

    private String daneAdresowe(Podmiot podmiot) {
        return Joiner.on((String)" ").join((Object)podmiot.getNazwa(), (Object)ADRES.print((Object)podmiot.getAdres(), ExtraLocales.PL).replaceAll("\n", " "), new Object[0]);
    }
}

