/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.przelewy;

import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.format.Printer;
import org.springframework.stereotype.Component;
import pl.topteam.jerzyk.konwertery.przelewy.Konwerter;
import pl.topteam.jerzyk.model.przelewy.Paczka;
import pl.topteam.jerzyk.model.przelewy.Podmiot;
import pl.topteam.jerzyk.model.przelewy.Zlecenie;
import pl.topteam.jerzyk.model.przelewy.citydirect.CityDirectPaczka;
import pl.topteam.jerzyk.model.przelewy.citydirect.CityDirectZlecenie;
import pl.topteam.jerzyk.model.przelewy.elixir.format.PodmiotPrinter;
import pl.topteam.jerzyk.narzedzia.Wrapper;

@Component
public class CityDirectKonwerter
implements Konwerter<CityDirectPaczka> {
    private static final Printer<Podmiot> PODMIOT = new PodmiotPrinter();
    private static final Wrapper WRAPPER = Wrapper.maxLength(35);
    private static final Splitter SPLITTER = Splitter.on((String)"\n");

    @Override
    public CityDirectPaczka konwertuj(Paczka paczka) {
        CityDirectPaczka _paczka = new CityDirectPaczka();
        ArrayList<CityDirectZlecenie> _zlecenia = new ArrayList<CityDirectZlecenie>();
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            CityDirectZlecenie _zlecenie = new CityDirectZlecenie();
            Verify.verifyNotNull((Object)paczka.getNadawca());
            Verify.verifyNotNull((Object)paczka.getNadawca().getKonto());
            _zlecenie.setNumerRachunkuObciazanego(paczka.getNadawca().getKonto().value().substring(16, 26));
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca().getKonto());
            _zlecenie.setNumerBankuBeneficjenta(zlecenie.getOdbiorca().getKonto().value().substring(2, 10));
            _zlecenie.setNumerRachunkuBeneficjenta(zlecenie.getOdbiorca().getKonto());
            _zlecenie.setNazwaIAdresBeneficjenta(CityDirectKonwerter.podmiot(zlecenie.getOdbiorca()));
            _zlecenie.setKwota(zlecenie.getKwota());
            _zlecenie.setDataWaluty(zlecenie.getData());
            Verify.verifyNotNull((Object)zlecenie.getTytul());
            _zlecenie.setSzczegolyPlatnosci(CityDirectKonwerter.szczegolyPlatnosci(zlecenie.getTytul()));
            _zlecenia.add(_zlecenie);
        }
        _paczka.setZlecenia(_zlecenia);
        return _paczka;
    }

    private static List<String> podmiot(Podmiot podmiot) {
        List<String> nazwa = CityDirectKonwerter.wrap(PODMIOT.print((Object)podmiot, null));
        return CityDirectKonwerter.resize(nazwa, 3);
    }

    private static List<String> szczegolyPlatnosci(String tytul) {
        List<String> komentarz = CityDirectKonwerter.wrap(tytul);
        return CityDirectKonwerter.resize(komentarz, 4);
    }

    private static List<String> resize(List<String> list, int size) {
        while (list.size() < size) {
            list.add("");
        }
        return list;
    }

    private static List<String> wrap(String string) {
        return Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)WRAPPER.wrap(string)));
    }
}

