/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.przelewy;

import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.format.Printer;
import org.springframework.stereotype.Component;
import pl.topteam.common.util.ExtraLocales;
import pl.topteam.jerzyk.konwertery.przelewy.Konwerter;
import pl.topteam.jerzyk.model.przelewy.Paczka;
import pl.topteam.jerzyk.model.przelewy.Podmiot;
import pl.topteam.jerzyk.model.przelewy.Zlecenie;
import pl.topteam.jerzyk.model.przelewy.elixir.ElixirPaczka;
import pl.topteam.jerzyk.model.przelewy.elixir.ElixirZlecenie;
import pl.topteam.jerzyk.model.przelewy.elixir.format.PodmiotPrinter;
import pl.topteam.jerzyk.model.przelewy.elixir.typy.TypDokumentu;
import pl.topteam.jerzyk.model.przelewy.elixir.typy.TypKomunikatu;
import pl.topteam.jerzyk.narzedzia.Wrapper;

@Component
public class ElixirKonwerter
implements Konwerter<ElixirPaczka> {
    private static final Printer<Podmiot> PODMIOT = new PodmiotPrinter();
    private static final Wrapper WRAPPER = Wrapper.maxLength(35);
    private static final Splitter SPLITTER = Splitter.on((String)"\n");

    @Override
    public ElixirPaczka konwertuj(Paczka paczka) {
        ElixirPaczka _paczka = new ElixirPaczka();
        ArrayList<ElixirZlecenie> _zlecenia = new ArrayList<ElixirZlecenie>();
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            ElixirZlecenie _zlecenie = new ElixirZlecenie();
            _zlecenie.setTypKomunikatu(TypKomunikatu.KRAJOWY);
            _zlecenie.setDataPlanowanegoWykonaniaZlecen(zlecenie.getData());
            Verify.verifyNotNull((Object)zlecenie.getKwota());
            _zlecenie.setKwotaZleceniaGr(zlecenie.getKwota().movePointRight(2).longValueExact());
            Verify.verifyNotNull((Object)paczka.getNadawca());
            Verify.verifyNotNull((Object)paczka.getNadawca().getKonto());
            _zlecenie.setNumerRozliczeniowyBankuNadawcy(paczka.getNadawca().getKonto().value().substring(2, 10));
            _zlecenie.setNumerRozliczeniowyBankuOdbiorcy("0");
            _zlecenie.setNumerRachunkuNadawcy(paczka.getNadawca().getKonto());
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca().getKonto());
            _zlecenie.setNumerRachunkuBeneficjenta(zlecenie.getOdbiorca().getKonto());
            _zlecenie.setNazwaRachunkuZleceniodawcy(ElixirKonwerter.wrap(PODMIOT.print((Object)paczka.getNadawca(), ExtraLocales.PL)));
            _zlecenie.setNazwaRachunkuBeneficjenta(ElixirKonwerter.wrap(PODMIOT.print((Object)zlecenie.getOdbiorca(), ExtraLocales.PL)));
            _zlecenie.setNumerNadawcyUczestnikaPosredniego("0");
            _zlecenie.setNumerOddzialuFinalnyAdresat(zlecenie.getOdbiorca().getKonto().value().substring(2, 10));
            Verify.verifyNotNull((Object)zlecenie.getTytul());
            _zlecenie.setReferencja(ElixirKonwerter.wrap(zlecenie.getTytul()));
            _zlecenie.setTypDokumentu(TypDokumentu.KRAJOWY);
            _zlecenia.add(_zlecenie);
        }
        _paczka.setZlecenia(_zlecenia);
        return _paczka;
    }

    private static List<String> wrap(String string) {
        return Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)WRAPPER.wrap(string)));
    }
}

