/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.przelewy;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field23B;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field50K;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field59;
import com.prowidesoftware.swift.model.field.Field70;
import com.prowidesoftware.swift.model.field.Field71A;
import com.prowidesoftware.swift.model.mt.mt1xx.MT103;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.format.Printer;
import org.springframework.stereotype.Component;
import pl.topteam.common.model.NRB;
import pl.topteam.common.util.ExtraLocales;
import pl.topteam.jerzyk.konwertery.przelewy.Konwerter;
import pl.topteam.jerzyk.model.przelewy.Paczka;
import pl.topteam.jerzyk.model.przelewy.Podmiot;
import pl.topteam.jerzyk.model.przelewy.Zlecenie;
import pl.topteam.jerzyk.model.przelewy.elixir.format.PodmiotPrinter;
import pl.topteam.jerzyk.model.przelewy.mt103.MT103Paczka;
import pl.topteam.jerzyk.narzedzia.Wrapper;
import pl.topteam.tezaurus.banki_komercyjne.Bank;
import pl.topteam.tezaurus.banki_komercyjne.Banki;
import pl.topteam.tezaurus.banki_komercyjne.Jednostka;
import pl.topteam.tezaurus.banki_komercyjne.Jednostki;

@Component
public class MT103Konwerter
implements Konwerter<MT103Paczka> {
    private static final Printer<Podmiot> PODMIOT = new PodmiotPrinter();
    private static final Wrapper WRAPPER = Wrapper.maxLength(35);
    private static final Splitter SPLITTER = Splitter.on((String)"\n");
    private static final String WALUTA = "PLN";
    private static final Map<String, String> SWIFT;

    @Override
    public MT103Paczka konwertuj(Paczka paczka) {
        MT103Paczka _paczka = new MT103Paczka();
        ArrayList<MT103> _zlecenia = new ArrayList<MT103>();
        int lp = 1;
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            MT103 _zlecenie = new MT103();
            Verify.verifyNotNull((Object)zlecenie.getIdentyfikator());
            _zlecenie.addField((Field)new Field20(zlecenie.getIdentyfikator()));
            _zlecenie.addField((Field)new Field23B("CRED"));
            _zlecenie.addField(MT103Konwerter.field32A(zlecenie));
            Verify.verifyNotNull((Object)paczka.getNadawca());
            _zlecenie.addField(MT103Konwerter.field50K(paczka.getNadawca()));
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            _zlecenie.addField(MT103Konwerter.field52A(zlecenie.getOdbiorca()));
            _zlecenie.addField(MT103Konwerter.field57A(paczka.getNadawca()));
            _zlecenie.addField(MT103Konwerter.field59(zlecenie.getOdbiorca()));
            Verify.verifyNotNull((Object)zlecenie.getTytul());
            _zlecenie.addField(MT103Konwerter.field70(zlecenie.getTytul()));
            _zlecenie.addField((Field)new Field71A("BEN"));
            _zlecenie.getSwiftMessage().setBlock1(this.swiftBlock1(paczka, lp));
            _zlecenie.getSwiftMessage().setBlock2((SwiftBlock2)this.swiftBlock2(zlecenie));
            _zlecenia.add(_zlecenie);
            ++lp;
        }
        _paczka.setZlecenia(_zlecenia);
        return _paczka;
    }

    private SwiftBlock1 swiftBlock1(Paczka paczka, int lp) {
        SwiftBlock1 b1 = new SwiftBlock1();
        b1.setApplicationId("F");
        b1.setServiceId("01");
        Verify.verifyNotNull((Object)paczka.getNadawca());
        Verify.verifyNotNull((Object)paczka.getNadawca().getKonto());
        b1.setLogicalTerminal(Strings.padEnd((String)paczka.getNadawca().getKonto().value().substring(2, 10), (int)12, (char)'x'));
        b1.setSessionNumber("0001");
        b1.setSequenceNumber(Strings.padStart((String)Integer.toString(lp), (int)6, (char)'0'));
        return b1;
    }

    private SwiftBlock2Input swiftBlock2(Zlecenie zlecenie) {
        SwiftBlock2Input b2 = new SwiftBlock2Input();
        b2.setMessageType("100");
        Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
        Verify.verifyNotNull((Object)zlecenie.getOdbiorca().getKonto());
        b2.setReceiverAddress(Strings.padEnd((String)MT103Konwerter.swift(zlecenie.getOdbiorca().getKonto()), (int)12, (char)'x'));
        b2.setDeliveryMonitoring("1");
        return b2;
    }

    private static Field field32A(Zlecenie zlecenie) {
        Field32A f32A = new Field32A();
        Verify.verifyNotNull((Object)zlecenie.getData());
        f32A.setDate(MT103Konwerter.calendar(zlecenie.getData()));
        f32A.setCurrency(WALUTA);
        f32A.setAmount((Number)zlecenie.getKwota());
        return f32A;
    }

    private static Field field50K(Podmiot nadawca) {
        Field50K f50K = new Field50K();
        Verify.verifyNotNull((Object)nadawca.getKonto());
        f50K.setAccount(nadawca.getKonto().toIBAN().value());
        f50K.setNameAndAddress(WRAPPER.wrap(PODMIOT.print((Object)nadawca, ExtraLocales.PL)));
        return f50K;
    }

    private static Field field52A(Podmiot nadawca) {
        Field52A f52A = new Field52A();
        Verify.verifyNotNull((Object)nadawca.getKonto());
        String swift = MT103Konwerter.swift(nadawca.getKonto());
        f52A.setIdentifierCode(swift);
        return f52A;
    }

    private static Field field57A(Podmiot odbiorca) {
        Field57A f57A = new Field57A();
        Verify.verifyNotNull((Object)odbiorca.getKonto());
        String swift = MT103Konwerter.swift(odbiorca.getKonto());
        f57A.setIdentifierCode(swift);
        return f57A;
    }

    private static Field field59(Podmiot odbiorca) {
        Field59 f59 = new Field59();
        Verify.verifyNotNull((Object)odbiorca.getKonto());
        f59.setAccount(odbiorca.getKonto().toIBAN().value());
        f59.setNameAndAddress(WRAPPER.wrap(PODMIOT.print((Object)odbiorca, ExtraLocales.PL)));
        return f59;
    }

    private static Field field70(String tytul) {
        Field70 f70 = new Field70();
        f70.setComponents(MT103Konwerter.wrap(tytul));
        return f70;
    }

    private static String swift(NRB nrb) {
        String swift = SWIFT.get(nrb.value().substring(2, 10));
        Preconditions.checkArgument((swift != null ? 1 : 0) != 0);
        return swift;
    }

    private static List<String> wrap(String string) {
        return Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)WRAPPER.wrap(string)));
    }

    private static Calendar calendar(LocalDate data) {
        return new GregorianCalendar(data.getYear(), data.getMonthValue() - 1, data.getDayOfMonth());
    }

    static {
        try {
            Map banki = (Map)Banki.wczytaj().stream().collect(ImmutableMap.toImmutableMap(Bank::numer, Function.identity()));
            SWIFT = (Map)Jednostki.wczytaj((Map)banki).stream().collect(ImmutableMap.toImmutableMap(Jednostka::numer, Jednostka::swift));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

