/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.przelewy;

import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.format.Printer;
import org.springframework.stereotype.Component;
import pl.topteam.common.format.kontakty.AdresPrinter;
import pl.topteam.common.model.kontakty.Adres;
import pl.topteam.common.util.ExtraLocales;
import pl.topteam.jerzyk.konwertery.przelewy.Konwerter;
import pl.topteam.jerzyk.model.przelewy.Paczka;
import pl.topteam.jerzyk.model.przelewy.Podmiot;
import pl.topteam.jerzyk.model.przelewy.Zlecenie;
import pl.topteam.jerzyk.model.przelewy.multicash.MultiCashPaczka;
import pl.topteam.jerzyk.model.przelewy.multicash.MultiCashZlecenie;
import pl.topteam.jerzyk.model.przelewy.multicash.typy.NazwaIAdres;
import pl.topteam.jerzyk.model.przelewy.multicash.typy.Parametr;
import pl.topteam.jerzyk.model.przelewy.multicash.typy.Typ;
import pl.topteam.jerzyk.narzedzia.Wrapper;

@Component
public class MultiCashKonwerter
implements Konwerter<MultiCashPaczka> {
    private static final Printer<Adres> ADRES = new AdresPrinter();
    private static final Wrapper WRAPPER = Wrapper.maxLength(35);
    private static final Splitter SPLITTER = Splitter.on((String)"\n");

    @Override
    public MultiCashPaczka konwertuj(Paczka paczka) {
        MultiCashPaczka _paczka = new MultiCashPaczka();
        ArrayList<MultiCashZlecenie> _zlecenia = new ArrayList<MultiCashZlecenie>();
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            MultiCashZlecenie multiCashZlecenie = new MultiCashZlecenie();
            multiCashZlecenie.setTyp(Typ.KRAJOWY);
            multiCashZlecenie.setData(zlecenie.getData());
            Verify.verifyNotNull((Object)zlecenie.getKwota());
            multiCashZlecenie.setKwotaGr(zlecenie.getKwota().movePointRight(2).longValueExact());
            Verify.verifyNotNull((Object)paczka.getNadawca());
            Verify.verifyNotNull((Object)paczka.getNadawca().getKonto());
            multiCashZlecenie.setNumerOddzialu(paczka.getNadawca().getKonto().value().substring(2, 10));
            multiCashZlecenie.setNumerRachunkuKlienta(paczka.getNadawca().getKonto());
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca().getKonto());
            multiCashZlecenie.setNumerRachunkuBeneficjenta(zlecenie.getOdbiorca().getKonto());
            multiCashZlecenie.setNazwaKlienta(MultiCashKonwerter.nazwaIAdres(paczka.getNadawca()));
            multiCashZlecenie.setNazwaBeneficjenta(MultiCashKonwerter.nazwaIAdres(zlecenie.getOdbiorca()));
            multiCashZlecenie.setNumerOddzialuBeneficjenta(zlecenie.getOdbiorca().getKonto().value().substring(2, 10));
            Verify.verifyNotNull((Object)zlecenie.getTytul());
            multiCashZlecenie.setKomentarz(MultiCashKonwerter.komentarz(zlecenie.getTytul()));
            multiCashZlecenie.setParametr(Parametr.KRAJOWY);
            _zlecenia.add(multiCashZlecenie);
        }
        _paczka.setZlecenia(_zlecenia);
        return _paczka;
    }

    private static NazwaIAdres nazwaIAdres(Podmiot podmiot) {
        NazwaIAdres nazwaIAdres = new NazwaIAdres();
        nazwaIAdres.setNazwa(MultiCashKonwerter.wrapNazwa(podmiot, 2));
        nazwaIAdres.setAdres(MultiCashKonwerter.wrapAdres(podmiot, 2));
        return nazwaIAdres;
    }

    private static List<String> wrapNazwa(Podmiot podmiot, int rozmiar) {
        Verify.verifyNotNull((Object)podmiot.getNazwa());
        List<String> nazwa = MultiCashKonwerter.wrap(podmiot.getNazwa());
        return MultiCashKonwerter.resize(nazwa, rozmiar);
    }

    private static List<String> wrapAdres(Podmiot podmiot, int rozmiar) {
        Verify.verifyNotNull((Object)podmiot.getAdres());
        List<String> adres = MultiCashKonwerter.wrap(ADRES.print((Object)podmiot.getAdres(), ExtraLocales.PL));
        return MultiCashKonwerter.resize(adres, rozmiar);
    }

    private static List<String> komentarz(String string) {
        List<String> komentarz = MultiCashKonwerter.wrap(string);
        return MultiCashKonwerter.resize(komentarz, 4);
    }

    private static List<String> resize(List<String> lista, int size) {
        while (lista.size() < size) {
            lista.add("");
        }
        return lista;
    }

    private static List<String> wrap(String string) {
        return Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)WRAPPER.wrap(string)));
    }
}

