/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.przelewy;

import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.format.Printer;
import org.springframework.stereotype.Component;
import pl.topteam.common.util.ExtraLocales;
import pl.topteam.jerzyk.konwertery.przelewy.Konwerter;
import pl.topteam.jerzyk.model.przelewy.Paczka;
import pl.topteam.jerzyk.model.przelewy.Podmiot;
import pl.topteam.jerzyk.model.przelewy.Zlecenie;
import pl.topteam.jerzyk.model.przelewy.elixir.format.PodmiotPrinter;
import pl.topteam.jerzyk.model.przelewy.videotel.VideoTELPaczka;
import pl.topteam.jerzyk.model.przelewy.videotel.VideoTELZlecenie;
import pl.topteam.jerzyk.narzedzia.Wrapper;

@Component
public class VideoTELKonwerter
implements Konwerter<VideoTELPaczka> {
    private static final Printer<Podmiot> PODMIOT = new PodmiotPrinter();
    private static final Wrapper WRAPPER = Wrapper.maxLength(35);
    private static final Splitter SPLITTER = Splitter.on((String)"\n");

    @Override
    public VideoTELPaczka konwertuj(Paczka paczka) {
        VideoTELPaczka _paczka = new VideoTELPaczka();
        _paczka.setDataPlanowanegoWykonaniaZlecen(paczka.getData());
        ArrayList<VideoTELZlecenie> _zlecenia = new ArrayList<VideoTELZlecenie>();
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            VideoTELZlecenie _zlecenie = new VideoTELZlecenie();
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            _zlecenie.setNazwaRachunkuBeneficjenta(VideoTELKonwerter.wrap(PODMIOT.print((Object)zlecenie.getOdbiorca(), ExtraLocales.PL)));
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca().getKonto());
            _zlecenie.setNumerRachunkuBeneficjenta(zlecenie.getOdbiorca().getKonto());
            _zlecenie.setKwotaZlecenia(zlecenie.getKwota());
            Verify.verifyNotNull((Object)paczka.getNadawca());
            _zlecenie.setNazwaRachunkuZleceniodawcy(VideoTELKonwerter.wrap(PODMIOT.print((Object)paczka.getNadawca(), ExtraLocales.PL)));
            Verify.verifyNotNull((Object)paczka.getNadawca().getKonto());
            _zlecenie.setNumerRachunkuZleceniodawcy(paczka.getNadawca().getKonto());
            Verify.verifyNotNull((Object)zlecenie.getTytul());
            _zlecenie.setReferencja(VideoTELKonwerter.wrap(zlecenie.getTytul()));
            _zlecenie.setNazwaSkroconaBeneficjenta(zlecenie.getOdbiorca().getNazwa());
            _zlecenie.setDomyslnaNazwaRachunkowPowiazanychZDanaFirmaNF(VideoTELKonwerter.wrap(PODMIOT.print((Object)zlecenie.getOdbiorca(), ExtraLocales.PL)));
            _zlecenie.setSygnaturaSystemuFinansowoOksiegowego(zlecenie.getIdentyfikator());
            _zlecenia.add(_zlecenie);
        }
        _paczka.setZlecenia(_zlecenia);
        return _paczka;
    }

    private static List<String> wrap(String string) {
        return Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)WRAPPER.wrap(string)));
    }
}

