/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.wyplaty;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Component;
import pl.topteam.common.model.kontakty.Adres;
import pl.topteam.jerzyk.konwertery.wyplaty.Konwerter;
import pl.topteam.jerzyk.model.wyplaty.Odbiorca;
import pl.topteam.jerzyk.model.wyplaty.Paczka;
import pl.topteam.jerzyk.model.wyplaty.Zlecenie;
import pl.topteam.jerzyk.model.wyplaty.ing.AutowyplataINGPaczka;
import pl.topteam.jerzyk.model.wyplaty.ing.AutowyplataINGZlecenie;
import pl.topteam.jerzyk.model.wyplaty.ing.typy.Flaga;
import pl.topteam.jerzyk.model.wyplaty.ing.typy.TypOsoby;

@Component
public class AutowyplataINGKonwerter
implements Konwerter<AutowyplataINGPaczka> {
    @Override
    public AutowyplataINGPaczka konwertuj(Paczka paczka) {
        AutowyplataINGPaczka _paczka = new AutowyplataINGPaczka();
        _paczka.setFlaga(Flaga.WYPLATA);
        Verify.verifyNotNull((Object)paczka.getNadawca());
        _paczka.setIDKlienta(paczka.getNadawca().getIdentyfikator());
        _paczka.setIDPliku(paczka.getIdentyfikator());
        ArrayList<AutowyplataINGZlecenie> _zlecenia = new ArrayList<AutowyplataINGZlecenie>();
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            AutowyplataINGZlecenie _zlecenie = new AutowyplataINGZlecenie();
            _zlecenie.setTypOsoby(TypOsoby.REZYDENT);
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            _zlecenie.setPesel(zlecenie.getOdbiorca().getPesel());
            _zlecenie.setDokumentTozsamosci(this.dokumentTozsamosci(zlecenie.getOdbiorca()));
            Verify.verifyNotNull((Object)paczka.getNadawca());
            _zlecenie.setRachunek(paczka.getNadawca().getKonto());
            _zlecenie.setKwota(zlecenie.getKwota());
            _zlecenie.setWaluta("PLN");
            _zlecenie.setTytul(zlecenie.getTytul());
            _zlecenie.setSygnatura(zlecenie.getIdentyfikator());
            _zlecenie.setDataOd(zlecenie.getDataOd());
            _zlecenie.setDataDo(zlecenie.getDataDo());
            _zlecenie.setDanePersonalne(zlecenie.getOdbiorca().getNazwa());
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca().getAdres());
            _zlecenie.setAdres(this.adres(zlecenie.getOdbiorca().getAdres()));
            _zlecenia.add(_zlecenie);
        }
        _paczka.setZlecenia(_zlecenia);
        return _paczka;
    }

    private String adres(Adres adres) {
        return Joiner.on((String)" ").skipNulls().join((Object)adres.getMiejscowosc(), (Object)adres.getUlica(), new Object[]{adres.getBudynek(), adres.getLokal()});
    }

    private @Nullable String dokumentTozsamosci(Odbiorca odbiorca) {
        return odbiorca.getDowod() != null ? odbiorca.getDowod().value() : (odbiorca.getPaszport() != null ? odbiorca.getPaszport().value() : null);
    }
}

