/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.wyplaty;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Component;
import pl.pkobp.platin.mmw.CtAC_BRANCHES_AGENCIES;
import pl.pkobp.platin.mmw.CtAC_SEND_BANK;
import pl.pkobp.platin.mmw.CtBNF;
import pl.pkobp.platin.mmw.CtDCA;
import pl.pkobp.platin.mmw.CtORDER_CUSTOMER;
import pl.pkobp.platin.mmw.CtORDER_CUSTOMER_B;
import pl.pkobp.platin.mmw.CtSEQUANCE_AC;
import pl.pkobp.platin.mmw.CtSEQUANCE_B;
import pl.pkobp.platin.mmw.XML_DPW;
import pl.topteam.common.model.NRB;
import pl.topteam.common.model.kontakty.Adres;
import pl.topteam.jerzyk.konwertery.wyplaty.Konwerter;
import pl.topteam.jerzyk.model.wyplaty.Nadawca;
import pl.topteam.jerzyk.model.wyplaty.Odbiorca;
import pl.topteam.jerzyk.model.wyplaty.Paczka;
import pl.topteam.jerzyk.model.wyplaty.Zlecenie;
import pl.topteam.jerzyk.narzedzia.Wrapper;
import pl.topteam.tezaurus.banki_komercyjne.Bank;
import pl.topteam.tezaurus.banki_komercyjne.Banki;
import pl.topteam.tezaurus.banki_komercyjne.Jednostka;
import pl.topteam.tezaurus.banki_komercyjne.Jednostki;

@Component
public class AutowyplataMasowaPekaoKonwerter
implements Konwerter<XML_DPW> {
    private static final Wrapper WRAPPER = Wrapper.maxLength(35);
    private static final Splitter SPLITTER = Splitter.on((String)"\n");
    private static final Map<String, String> SWIFT;

    @Override
    public XML_DPW konwertuj(Paczka paczka) {
        XML_DPW xml_dpw = new XML_DPW();
        xml_dpw.setDSP(this.dsp(paczka));
        return xml_dpw;
    }

    private XML_DPW.DSP dsp(Paczka paczka) {
        XML_DPW.DSP dsp = new XML_DPW.DSP();
        dsp.setSEQ_AC(this.seq_ac(paczka));
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            CtSEQUANCE_B sequance_b = new CtSEQUANCE_B();
            Verify.verifyNotNull((Object)zlecenie.getIdentyfikator());
            sequance_b.setB_SENDER_REF(zlecenie.getIdentyfikator());
            Verify.verifyNotNull((Object)zlecenie.getKwota());
            sequance_b.setB_DCA(this.b_dca(zlecenie.getKwota()));
            Verify.verifyNotNull((Object)paczka.getNadawca());
            sequance_b.setB_ORDER_CUST(this.b_order_cust(paczka.getNadawca()));
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            sequance_b.setB_BNF(this.b_bnf(zlecenie.getOdbiorca()));
            sequance_b.setB_CHARGES_DETAIL("BEN");
            sequance_b.setB_FEATURE((byte)3);
            sequance_b.setB_INFORMATION_REMITTANCES(this.b_information_remittances(zlecenie));
            sequance_b.setB_INFO_FOR_RECS(this.b_info_for_recs(zlecenie));
            dsp.getSEQ_B().add(sequance_b);
        }
        return dsp;
    }

    private CtSEQUANCE_AC seq_ac(Paczka paczka) {
        CtSEQUANCE_AC seq_ac = new CtSEQUANCE_AC();
        Verify.verifyNotNull((Object)paczka.getNadawca());
        seq_ac.setAC_SEND_BANK(this.ac_send_bank(paczka.getNadawca()));
        seq_ac.setAC_BRANCHES_AGENCIES(this.ac_branches_agencies());
        seq_ac.setAC_FILE_NUMBER((short)1);
        seq_ac.setAC_NUMBER_OF_FILES((short)1);
        Verify.verifyNotNull((Object)paczka.getIdentyfikator());
        seq_ac.setAC_SENDER_REF(paczka.getIdentyfikator());
        seq_ac.setAC_INCOME_DATE(LocalDateTime.now());
        seq_ac.setAC_ORDER_CUST_REST(this.ac_order_cust_rest(paczka.getNadawca()));
        Verify.verifyNotNull(paczka.getZlecenia());
        seq_ac.setAC_DCA(this.ac_dca(paczka.getZlecenia()));
        seq_ac.setAC_COUNT(paczka.getZlecenia().size());
        seq_ac.setAC_SUM_OF_AMOUNTS(this.suma(paczka.getZlecenia()));
        return seq_ac;
    }

    private CtAC_SEND_BANK ac_send_bank(Nadawca nadawca) {
        CtAC_SEND_BANK ac_send_bank = new CtAC_SEND_BANK();
        Verify.verifyNotNull((Object)nadawca.getKonto());
        String bic = AutowyplataMasowaPekaoKonwerter.bic(nadawca.getKonto());
        ac_send_bank.setAC_SEND_BANK_BIC(bic);
        ac_send_bank.setAC_SEND_BANK_SOURCE(bic.substring(0, 8));
        ac_send_bank.setAC_BANK_ACCOUNT(nadawca.getKonto().value());
        ac_send_bank.setAC_DATE_FROM(null);
        ac_send_bank.setAC_DATE_TO(null);
        ac_send_bank.setAC_IN_AGENCIES("T");
        return ac_send_bank;
    }

    private CtAC_BRANCHES_AGENCIES ac_branches_agencies() {
        CtAC_BRANCHES_AGENCIES ac_branches_agencies = new CtAC_BRANCHES_AGENCIES();
        return ac_branches_agencies;
    }

    private CtORDER_CUSTOMER ac_order_cust_rest(Nadawca nadawca) {
        CtORDER_CUSTOMER ac_order_cust_rest = new CtORDER_CUSTOMER();
        ac_order_cust_rest.setORDER_CUST_NAME_ADRS(this.order_cust_name_adrs(nadawca));
        return ac_order_cust_rest;
    }

    private CtORDER_CUSTOMER.ORDER_CUST_NAME_ADRS order_cust_name_adrs(Nadawca nadawca) {
        CtORDER_CUSTOMER.ORDER_CUST_NAME_ADRS order_cust_name_adrs = new CtORDER_CUSTOMER.ORDER_CUST_NAME_ADRS();
        order_cust_name_adrs.getORDER_CUST_NAME_ADR().add(nadawca.getNazwa());
        Verify.verifyNotNull((Object)nadawca.getAdres());
        order_cust_name_adrs.getORDER_CUST_NAME_ADR().add(AutowyplataMasowaPekaoKonwerter.miejscowosc(nadawca.getAdres()));
        order_cust_name_adrs.getORDER_CUST_NAME_ADR().add(AutowyplataMasowaPekaoKonwerter.ulica(nadawca.getAdres()));
        return order_cust_name_adrs;
    }

    private CtDCA ac_dca(List<Zlecenie> zlecenia) {
        CtDCA ac_dca = new CtDCA();
        ac_dca.setDCA_AMOUNT(this.suma(zlecenia));
        ac_dca.setDCA_CURR("PLN");
        ac_dca.setDCA_DATE(LocalDate.now());
        return ac_dca;
    }

    private CtSEQUANCE_B.B_DCA b_dca(BigDecimal kwota) {
        CtSEQUANCE_B.B_DCA b_dca = new CtSEQUANCE_B.B_DCA();
        b_dca.setB_DCA_AMOUNT(kwota);
        b_dca.setB_DCA_CURR("PLN");
        return b_dca;
    }

    private CtORDER_CUSTOMER_B b_order_cust(Nadawca nadawca) {
        CtORDER_CUSTOMER_B b_order_cust = new CtORDER_CUSTOMER_B();
        b_order_cust.setORDER_CUST_NAME_ADRS(this.ordercustnameadrsZlecenie(nadawca));
        return b_order_cust;
    }

    private CtORDER_CUSTOMER_B.ORDER_CUST_NAME_ADRS ordercustnameadrsZlecenie(Nadawca nadawca) {
        CtORDER_CUSTOMER_B.ORDER_CUST_NAME_ADRS order_cust_name_adrs = new CtORDER_CUSTOMER_B.ORDER_CUST_NAME_ADRS();
        order_cust_name_adrs.getORDER_CUST_NAME_ADR().add(nadawca.getNazwa());
        Verify.verifyNotNull((Object)nadawca.getAdres());
        order_cust_name_adrs.getORDER_CUST_NAME_ADR().add(AutowyplataMasowaPekaoKonwerter.miejscowosc(nadawca.getAdres()));
        order_cust_name_adrs.getORDER_CUST_NAME_ADR().add(AutowyplataMasowaPekaoKonwerter.ulica(nadawca.getAdres()));
        return order_cust_name_adrs;
    }

    private CtBNF b_bnf(Odbiorca odbiorca) {
        CtBNF b_bnf = new CtBNF();
        b_bnf.setB_BNF_NAME_ADRS(this.b_bnf_name_adrs(odbiorca));
        return b_bnf;
    }

    private CtBNF.B_BNF_NAME_ADRS b_bnf_name_adrs(Odbiorca odbiorca) {
        CtBNF.B_BNF_NAME_ADRS b_bnf_name_adrs = new CtBNF.B_BNF_NAME_ADRS();
        if (odbiorca.getPesel() != null) {
            b_bnf_name_adrs.setB_BNF_IDENTITY_TYPE((byte)1);
            b_bnf_name_adrs.setB_BNF_IDENTITY_NUMBER(odbiorca.getPesel().value());
        } else if (odbiorca.getDowod() != null) {
            b_bnf_name_adrs.setB_BNF_IDENTITY_TYPE((byte)2);
            b_bnf_name_adrs.setB_BNF_IDENTITY_NUMBER(odbiorca.getDowod().value());
        } else if (odbiorca.getPaszport() != null) {
            b_bnf_name_adrs.setB_BNF_IDENTITY_TYPE((byte)3);
            b_bnf_name_adrs.setB_BNF_IDENTITY_NUMBER(odbiorca.getPaszport().value());
        }
        b_bnf_name_adrs.getB_BNF_NAME_ADR().add(odbiorca.getNazwa());
        Verify.verifyNotNull((Object)odbiorca.getAdres());
        b_bnf_name_adrs.getB_BNF_NAME_ADR().add(AutowyplataMasowaPekaoKonwerter.miejscowosc(odbiorca.getAdres()));
        b_bnf_name_adrs.getB_BNF_NAME_ADR().add(AutowyplataMasowaPekaoKonwerter.ulica(odbiorca.getAdres()));
        return b_bnf_name_adrs;
    }

    private CtSEQUANCE_B.B_INFORMATION_REMITTANCES b_information_remittances(Zlecenie zlecenie) {
        CtSEQUANCE_B.B_INFORMATION_REMITTANCES b_information_remittances = new CtSEQUANCE_B.B_INFORMATION_REMITTANCES();
        Verify.verifyNotNull((Object)zlecenie.getTytul());
        b_information_remittances.getB_INFORMATION_REMITTANCE().addAll(AutowyplataMasowaPekaoKonwerter.wrapTytulZlecenia(zlecenie.getTytul()));
        return b_information_remittances;
    }

    private CtSEQUANCE_B.B_INFO_FOR_RECS b_info_for_recs(Zlecenie zlecenie) {
        CtSEQUANCE_B.B_INFO_FOR_RECS b_info_for_recs = new CtSEQUANCE_B.B_INFO_FOR_RECS();
        Verify.verifyNotNull((Object)zlecenie.getTytul());
        b_info_for_recs.getB_INFO_FOR_REC().addAll(AutowyplataMasowaPekaoKonwerter.wrapTytulZlecenia(zlecenie.getTytul()));
        return b_info_for_recs;
    }

    private static String miejscowosc(Adres adres) {
        return Joiner.on((String)" ").skipNulls().join((Object)adres.getKod(), (Object)adres.getMiejscowosc(), new Object[0]);
    }

    private static String ulica(Adres adres) {
        return Joiner.on((String)" ").skipNulls().join((Object)adres.getUlica(), (Object)adres.getBudynek(), new Object[]{AutowyplataMasowaPekaoKonwerter.lokal(adres.getLokal())});
    }

    private static @Nullable String lokal(String lokal) {
        return lokal != null ? "lok. " + lokal : null;
    }

    private static List<String> wrapTytulZlecenia(String tytulZlecenia) {
        return AutowyplataMasowaPekaoKonwerter.wrap(tytulZlecenia);
    }

    private static List<String> wrap(String string) {
        return Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)WRAPPER.wrap(string)));
    }

    private BigDecimal suma(List<Zlecenie> zlecenia) {
        return zlecenia.stream().map(Zlecenie::getKwota).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static String bic(NRB nrb) {
        String swift = SWIFT.get(nrb.value().substring(2, 10));
        Preconditions.checkArgument((swift != null ? 1 : 0) != 0);
        return swift;
    }

    static {
        try {
            Map banki = (Map)Banki.wczytaj().stream().collect(ImmutableMap.toImmutableMap(Bank::numer, Function.identity()));
            SWIFT = (Map)Jednostki.wczytaj((Map)banki).stream().collect(ImmutableMap.toImmutableMap(Jednostka::numer, Jednostka::swift));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

