/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.wyplaty;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Component;
import pl.topteam.common.model.kontakty.Adres;
import pl.topteam.jerzyk.konwertery.wyplaty.Konwerter;
import pl.topteam.jerzyk.model.wyplaty.Odbiorca;
import pl.topteam.jerzyk.model.wyplaty.Paczka;
import pl.topteam.jerzyk.model.wyplaty.Zlecenie;
import pl.topteam.jerzyk.model.wyplaty.mikrus.AutowyplataMikrusPaczka;
import pl.topteam.jerzyk.model.wyplaty.mikrus.AutowyplataMikrusZlecenie;
import pl.topteam.jerzyk.model.wyplaty.mikrus.typy.TypIdentyfikatora;

@Component
public class AutowyplataMikrusKonwerter
implements Konwerter<AutowyplataMikrusPaczka> {
    @Override
    public AutowyplataMikrusPaczka konwertuj(Paczka paczka) {
        AutowyplataMikrusPaczka _paczka = new AutowyplataMikrusPaczka();
        ArrayList<AutowyplataMikrusZlecenie> _zlecenia = new ArrayList<AutowyplataMikrusZlecenie>();
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            AutowyplataMikrusZlecenie _zlecenie = new AutowyplataMikrusZlecenie();
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            _zlecenie.setImieNazwisko(zlecenie.getOdbiorca().getNazwa());
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca().getAdres());
            _zlecenie.setUlicaDomLokal(AutowyplataMikrusKonwerter.ulicaDomLokal(zlecenie.getOdbiorca().getAdres()));
            _zlecenie.setMiejscowosc(AutowyplataMikrusKonwerter.miejscowosc(zlecenie.getOdbiorca().getAdres()));
            _zlecenie.setTytulPlatnosci(zlecenie.getTytul());
            _zlecenie.setKwota(zlecenie.getKwota());
            _zlecenie.setTypIdentyfikatora(this.typIdentyfikatora(zlecenie.getOdbiorca()));
            _zlecenie.setIdentyfikator(this.identyfikator(zlecenie.getOdbiorca()));
            _zlecenie.setTelefon(zlecenie.getOdbiorca().getTelefon());
            _zlecenia.add(_zlecenie);
        }
        _paczka.setZlecenia(_zlecenia);
        return _paczka;
    }

    private @Nullable TypIdentyfikatora typIdentyfikatora(Odbiorca odbiorca) {
        return odbiorca.getPesel() != null ? TypIdentyfikatora.PESEL : (odbiorca.getDowod() != null ? TypIdentyfikatora.NR_DOWODU : (odbiorca.getPaszport() != null ? TypIdentyfikatora.PASZPORT : null));
    }

    private @Nullable String identyfikator(Odbiorca odbiorca) {
        return odbiorca.getPesel() != null ? odbiorca.getPesel().value() : (odbiorca.getDowod() != null ? odbiorca.getDowod().value() : (odbiorca.getPaszport() != null ? odbiorca.getPaszport().value() : null));
    }

    private static String ulicaDomLokal(Adres adres) {
        return Joiner.on((String)" ").skipNulls().join((Object)adres.getUlica(), (Object)adres.getBudynek(), new Object[]{adres.getLokal()});
    }

    private static String miejscowosc(Adres adres) {
        return Strings.nullToEmpty((String)adres.getMiejscowosc());
    }
}

