/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.wyplaty;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Component;
import pl.topteam.common.model.PESEL;
import pl.topteam.common.model.dokumenty.DowodOsobisty;
import pl.topteam.common.model.dokumenty.Paszport;
import pl.topteam.common.model.kontakty.Adres;
import pl.topteam.jerzyk.konwertery.wyplaty.Konwerter;
import pl.topteam.jerzyk.model.wyplaty.Nadawca;
import pl.topteam.jerzyk.model.wyplaty.Odbiorca;
import pl.topteam.jerzyk.model.wyplaty.Paczka;
import pl.topteam.jerzyk.model.wyplaty.Zlecenie;
import pl.topteam.jerzyk.model.wyplaty.millenium.AutowyplataMilleniumPaczka;
import pl.topteam.jerzyk.model.wyplaty.millenium.AutowyplataMilleniumZlecenie;
import pl.topteam.jerzyk.model.wyplaty.millenium.typy.IdentyfikatorKontrahenta;
import pl.topteam.jerzyk.model.wyplaty.millenium.typy.NazwaIAdresOdbiorcy;
import pl.topteam.jerzyk.model.wyplaty.millenium.typy.NazwaIAdresZleceniodawcy;
import pl.topteam.jerzyk.narzedzia.Wrapper;

@Component
public class AutowyplataMilleniumKonwerter
implements Konwerter<AutowyplataMilleniumPaczka> {
    private static final Wrapper WRAPPER = Wrapper.maxLength(35);
    private static final Splitter SPLITTER = Splitter.on((String)"\n");

    @Override
    public AutowyplataMilleniumPaczka konwertuj(Paczka paczka) {
        AutowyplataMilleniumPaczka _paczka = new AutowyplataMilleniumPaczka();
        ArrayList<AutowyplataMilleniumZlecenie> _zlecenia = new ArrayList<AutowyplataMilleniumZlecenie>();
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            AutowyplataMilleniumZlecenie _zlecenie = new AutowyplataMilleniumZlecenie();
            Verify.verifyNotNull((Object)zlecenie.getKwota());
            _zlecenie.setKwota(zlecenie.getKwota().movePointRight(2).longValueExact());
            Verify.verifyNotNull((Object)paczka.getNadawca());
            Verify.verifyNotNull((Object)paczka.getNadawca().getKonto());
            _zlecenie.setNumerRozliczeniowyBankuZleceniodawcy(paczka.getNadawca().getKonto().value().substring(2, 10));
            _zlecenie.setRachunekZleceniodawcy(paczka.getNadawca().getKonto());
            _zlecenie.setNazwaIAdresZleceniodawcy(AutowyplataMilleniumKonwerter.nazwaIAdresZleceniodawcy(paczka.getNadawca()));
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            _zlecenie.setNazwaIAdresOdbiorcy(AutowyplataMilleniumKonwerter.nazwaIAdresOdbiorcy(zlecenie.getOdbiorca()));
            Verify.verifyNotNull((Object)zlecenie.getTytul());
            _zlecenie.setTytulZlecenia(AutowyplataMilleniumKonwerter.wrapTytulZlecenia(zlecenie.getTytul()));
            _zlecenie.setIdentyfikatorKontrahenta(AutowyplataMilleniumKonwerter.identyfikatorKontrahenta(zlecenie.getOdbiorca()));
            _zlecenia.add(_zlecenie);
        }
        _paczka.setZlecenia(_zlecenia);
        return _paczka;
    }

    private static NazwaIAdresZleceniodawcy nazwaIAdresZleceniodawcy(Nadawca nadawca) {
        NazwaIAdresZleceniodawcy nazwaIAdres = new NazwaIAdresZleceniodawcy();
        Verify.verifyNotNull((Object)nadawca.getNazwa());
        nazwaIAdres.setNazwa(AutowyplataMilleniumKonwerter.wrapNazwa(nadawca.getNazwa(), 1));
        Verify.verifyNotNull((Object)nadawca.getAdres());
        nazwaIAdres.setUlica(AutowyplataMilleniumKonwerter.ulica(nadawca.getAdres()));
        nazwaIAdres.setKodPocztowy(AutowyplataMilleniumKonwerter.kod(nadawca.getAdres()));
        nazwaIAdres.setMiejscowosc(AutowyplataMilleniumKonwerter.miejscowosc(nadawca.getAdres()));
        return nazwaIAdres;
    }

    private static NazwaIAdresOdbiorcy nazwaIAdresOdbiorcy(Odbiorca odbiorca) {
        NazwaIAdresOdbiorcy nazwaIAdres = new NazwaIAdresOdbiorcy();
        Verify.verifyNotNull((Object)odbiorca.getNazwa());
        nazwaIAdres.setNazwa(AutowyplataMilleniumKonwerter.wrapNazwa(odbiorca.getNazwa(), 2));
        Verify.verifyNotNull((Object)odbiorca.getAdres());
        nazwaIAdres.setUlica(AutowyplataMilleniumKonwerter.ulica(odbiorca.getAdres()));
        nazwaIAdres.setKodPocztowy(AutowyplataMilleniumKonwerter.kod(odbiorca.getAdres()));
        nazwaIAdres.setMiejscowosc(AutowyplataMilleniumKonwerter.miejscowosc(odbiorca.getAdres()));
        return nazwaIAdres;
    }

    private static @Nullable IdentyfikatorKontrahenta identyfikatorKontrahenta(Odbiorca odbiorca) {
        return odbiorca.getPesel() != null ? AutowyplataMilleniumKonwerter.identyfikatorKontrahenta(odbiorca.getPesel()) : (odbiorca.getDowod() != null ? AutowyplataMilleniumKonwerter.identyfikatorKontrahenta(odbiorca.getDowod()) : (odbiorca.getPaszport() != null ? AutowyplataMilleniumKonwerter.identyfikatorKontrahenta(odbiorca.getPaszport()) : null));
    }

    private static IdentyfikatorKontrahenta identyfikatorKontrahenta(PESEL pesel) {
        return AutowyplataMilleniumKonwerter.identyfikatorKontrahenta(IdentyfikatorKontrahenta.Typ.PESEL, pesel.value());
    }

    private static IdentyfikatorKontrahenta identyfikatorKontrahenta(DowodOsobisty dowod) {
        return AutowyplataMilleniumKonwerter.identyfikatorKontrahenta(IdentyfikatorKontrahenta.Typ.DOWOD_OSOBISTY, dowod.value());
    }

    private static IdentyfikatorKontrahenta identyfikatorKontrahenta(Paszport paszport) {
        return AutowyplataMilleniumKonwerter.identyfikatorKontrahenta(IdentyfikatorKontrahenta.Typ.PASZPORT, paszport.value());
    }

    private static IdentyfikatorKontrahenta identyfikatorKontrahenta(IdentyfikatorKontrahenta.Typ typ, String numer) {
        IdentyfikatorKontrahenta identyfikatorKontrahenta = new IdentyfikatorKontrahenta();
        identyfikatorKontrahenta.setTyp(typ);
        identyfikatorKontrahenta.setNumer(numer);
        return identyfikatorKontrahenta;
    }

    private static List<String> wrapNazwa(String nazwa, int rozmiar) {
        List<String> _nazwa = AutowyplataMilleniumKonwerter.wrap(nazwa);
        return AutowyplataMilleniumKonwerter.resize(_nazwa, rozmiar);
    }

    private static List<String> wrapTytulZlecenia(String tytulZlecenia) {
        return AutowyplataMilleniumKonwerter.wrap(tytulZlecenia);
    }

    private static String ulica(Adres adres) {
        return Joiner.on((String)" ").skipNulls().join((Object)adres.getUlica(), (Object)adres.getBudynek(), new Object[]{adres.getLokal()});
    }

    private static String miejscowosc(Adres adres) {
        return Strings.nullToEmpty((String)adres.getMiejscowosc());
    }

    private static String kod(Adres adres) {
        return Strings.nullToEmpty((String)adres.getKod());
    }

    private static List<String> resize(List<String> lista, int size) {
        while (lista.size() < size) {
            lista.add("");
        }
        return lista;
    }

    private static List<String> wrap(String string) {
        return Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)WRAPPER.wrap(string)));
    }
}

