/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.konwertery.wyplaty;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.format.Printer;
import org.springframework.stereotype.Component;
import pl.topteam.common.model.PESEL;
import pl.topteam.common.model.dokumenty.DowodOsobisty;
import pl.topteam.common.model.dokumenty.Paszport;
import pl.topteam.common.model.kontakty.Adres;
import pl.topteam.jerzyk.konwertery.wyplaty.Konwerter;
import pl.topteam.jerzyk.konwertery.wyplaty.format.NadawcaPrinter;
import pl.topteam.jerzyk.model.wyplaty.Nadawca;
import pl.topteam.jerzyk.model.wyplaty.Odbiorca;
import pl.topteam.jerzyk.model.wyplaty.Paczka;
import pl.topteam.jerzyk.model.wyplaty.Zlecenie;
import pl.topteam.jerzyk.model.wyplaty.pekao.AutowyplataPekaoPaczka;
import pl.topteam.jerzyk.model.wyplaty.pekao.AutowyplataPekaoZlecenie;
import pl.topteam.jerzyk.model.wyplaty.pekao.typy.DaneBeneficjenta;
import pl.topteam.jerzyk.model.wyplaty.pekao.typy.DokumentTozsamosci;
import pl.topteam.jerzyk.model.wyplaty.pekao.typy.TrybRealizacji;
import pl.topteam.jerzyk.narzedzia.Wrapper;

@Component
public class AutowyplataPekaoKonwerter
implements Konwerter<AutowyplataPekaoPaczka> {
    private static final Printer<Nadawca> NADAWCA = new NadawcaPrinter();
    private static final Wrapper WRAPPER = Wrapper.maxLength(35);
    private static final Splitter SPLITTER = Splitter.on((String)"\n");

    @Override
    public AutowyplataPekaoPaczka konwertuj(Paczka paczka) {
        AutowyplataPekaoPaczka _paczka = new AutowyplataPekaoPaczka();
        ArrayList<AutowyplataPekaoZlecenie> _zlecenia = new ArrayList<AutowyplataPekaoZlecenie>();
        Verify.verifyNotNull(paczka.getZlecenia());
        for (Zlecenie zlecenie : paczka.getZlecenia()) {
            AutowyplataPekaoZlecenie _zlecenie = new AutowyplataPekaoZlecenie();
            _zlecenie.setDataRealizacji(zlecenie.getDataOd());
            Verify.verifyNotNull((Object)zlecenie.getKwota());
            _zlecenie.setKwotaZleceniaGr(zlecenie.getKwota().movePointRight(2).longValueExact());
            Verify.verifyNotNull((Object)paczka.getNadawca());
            Verify.verifyNotNull((Object)paczka.getNadawca().getKonto());
            _zlecenie.setNumerRozliczeniowy(paczka.getNadawca().getKonto().value().substring(2, 10));
            _zlecenie.setNumerRachunku(paczka.getNadawca().getKonto());
            _zlecenie.setDaneZleceniodawcy(this.daneZleceniodawcy(paczka.getNadawca()));
            Verify.verifyNotNull((Object)zlecenie.getOdbiorca());
            _zlecenie.setDaneBeneficjenta(this.daneBeneficjenta(zlecenie.getOdbiorca()));
            _zlecenie.setDataKoncowa(zlecenie.getDataDo());
            Verify.verifyNotNull((Object)zlecenie.getTytul());
            _zlecenie.setTytulem(AutowyplataPekaoKonwerter.wrap(zlecenie.getTytul()));
            _zlecenie.setTrybRealizacji(TrybRealizacji.WYPLATA_W_CIEZAR_KONTA_KSIEGI_GLOWNEJ);
            _zlecenie.setDokumentTozsamosci(this.dokumentTozsamosci(zlecenie.getOdbiorca()));
            _zlecenie.setSygnaturaZlecenia(zlecenie.getIdentyfikator());
            _zlecenia.add(_zlecenie);
        }
        _paczka.setZlecenia(_zlecenia);
        return _paczka;
    }

    private @Nullable DokumentTozsamosci dokumentTozsamosci(Odbiorca odbiorca) {
        return odbiorca.getPesel() != null ? this.dokumentTozsamosci(odbiorca.getPesel()) : (odbiorca.getDowod() != null ? this.dokumentTozsamosci(odbiorca.getDowod()) : (odbiorca.getPaszport() != null ? this.dokumentTozsamosci(odbiorca.getPaszport()) : null));
    }

    private DokumentTozsamosci dokumentTozsamosci(PESEL pesel) {
        return this.dokumentTozsamosci(DokumentTozsamosci.Typ.PESEL, pesel.value());
    }

    private DokumentTozsamosci dokumentTozsamosci(DowodOsobisty dowod) {
        return this.dokumentTozsamosci(DokumentTozsamosci.Typ.DOWOD_OSOBISTY, dowod.value());
    }

    private DokumentTozsamosci dokumentTozsamosci(Paszport paszport) {
        return this.dokumentTozsamosci(DokumentTozsamosci.Typ.PASZPORT, paszport.value());
    }

    private DokumentTozsamosci dokumentTozsamosci(DokumentTozsamosci.Typ typ, String numer) {
        DokumentTozsamosci dokumentTozsamosci = new DokumentTozsamosci();
        dokumentTozsamosci.setTyp(typ);
        dokumentTozsamosci.setNumer(numer);
        return dokumentTozsamosci;
    }

    private List<String> daneZleceniodawcy(Nadawca nadawca) {
        return AutowyplataPekaoKonwerter.wrap(NADAWCA.print((Object)nadawca, null));
    }

    private DaneBeneficjenta daneBeneficjenta(Odbiorca odbiorca) {
        DaneBeneficjenta daneBeneficjenta = new DaneBeneficjenta();
        Verify.verifyNotNull((Object)odbiorca.getNazwa());
        daneBeneficjenta.setNazwa(AutowyplataPekaoKonwerter.wrapNazwa(odbiorca.getNazwa(), 2));
        Verify.verifyNotNull((Object)odbiorca.getAdres());
        daneBeneficjenta.setUlica(AutowyplataPekaoKonwerter.ulica(odbiorca.getAdres()));
        daneBeneficjenta.setKod(AutowyplataPekaoKonwerter.kod(odbiorca.getAdres()));
        daneBeneficjenta.setMiejscowosc(AutowyplataPekaoKonwerter.miejscowosc(odbiorca.getAdres()));
        return daneBeneficjenta;
    }

    private static List<String> wrapNazwa(String nazwa, int rozmiar) {
        List<String> _nazwa = AutowyplataPekaoKonwerter.wrap(nazwa);
        return AutowyplataPekaoKonwerter.resize(_nazwa, rozmiar);
    }

    private static String ulica(Adres adres) {
        return Joiner.on((String)" ").skipNulls().join((Object)adres.getUlica(), (Object)adres.getBudynek(), new Object[]{adres.getLokal()});
    }

    private static String miejscowosc(Adres adres) {
        return Strings.nullToEmpty((String)adres.getMiejscowosc());
    }

    private static String kod(Adres adres) {
        return Strings.nullToEmpty((String)adres.getKod());
    }

    private static List<String> resize(List<String> lista, int size) {
        while (lista.size() < size) {
            lista.add("");
        }
        return lista;
    }

    private static List<String> wrap(String string) {
        return Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)WRAPPER.wrap(string)));
    }
}

