/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.model.wyplaty.millenium;

import java.time.LocalDate;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import pl.topteam.common.model.NRB;
import pl.topteam.jerzyk.model.wyplaty.millenium.typy.IdentyfikatorKontrahenta;
import pl.topteam.jerzyk.model.wyplaty.millenium.typy.NazwaIAdresOdbiorcy;
import pl.topteam.jerzyk.model.wyplaty.millenium.typy.NazwaIAdresZleceniodawcy;
import pl.topteam.jerzyk.model.wyplaty.millenium.typy.TypWyplaty;

public class AutowyplataMilleniumZlecenie {
    @NotNull
    private Integer kodZlecenia = 110;
    private @Nullable LocalDate dataPoczatkuWaznosci;
    private @Nullable LocalDate dataKoncaWaznosci;
    @NotNull
    @Min(value=1L, message="Kwota nie mo\u017ce by\u0107 mniejsza od 0,01z\u0142")
    @Max(value=999999999999999L, message="Kwota nie mo\u017ce by\u0107 wi\u0119ksza od 9'999'999'999'999,99z\u0142")
    private @NotNull @Min(value=1L, message="Kwota nie mo\u017ce by\u0107 mniejsza od 0,01z\u0142") @Max(value=999999999999999L, message="Kwota nie mo\u017ce by\u0107 wi\u0119ksza od 9'999'999'999'999,99z\u0142") Long kwota;
    @Pattern(regexp="[0-9]{8}", message="Numer rozliczeniowy banku powinien sk\u0142ada\u0107 si\u0119 z 8 cyfr.")
    private @Nullable @Pattern(regexp="[0-9]{8}", message="Numer rozliczeniowy banku powinien sk\u0142ada\u0107 si\u0119 z 8 cyfr.") String numerRozliczeniowyBankuZleceniodawcy;
    @NotNull
    private NRB rachunekZleceniodawcy;
    private @Nullable @Valid NazwaIAdresZleceniodawcy nazwaIAdresZleceniodawcy;
    @NotNull
    @Valid
    private NazwaIAdresOdbiorcy nazwaIAdresOdbiorcy;
    @NotNull
    @Size(min=1, max=4)
    private @NotNull @Size(min=1, max=4) List<@NotNull @Size(max=35) @Pattern(regexp="[^|,\"]*") String> tytulZlecenia;
    private @Nullable TypWyplaty typWyplaty;
    @NotNull
    @Valid
    private IdentyfikatorKontrahenta identyfikatorKontrahenta;
    @Pattern(regexp="[0-9]{1,16}", message="Kod rekoncyliacji powinien sk\u0142ada\u0107 si\u0119 od 1 do 16 cyfr.")
    private @Nullable @Pattern(regexp="[0-9]{1,16}", message="Kod rekoncyliacji powinien sk\u0142ada\u0107 si\u0119 od 1 do 16 cyfr.") String kodRekoncyliacji;
    @Deprecated
    private @Nullable NRB kontoAIPP;

    @Generated
    public AutowyplataMilleniumZlecenie() {
    }

    @NotNull
    @Generated
    public Integer getKodZlecenia() {
        return this.kodZlecenia;
    }

    @Generated
    public @Nullable LocalDate getDataPoczatkuWaznosci() {
        return this.dataPoczatkuWaznosci;
    }

    @Generated
    public @Nullable LocalDate getDataKoncaWaznosci() {
        return this.dataKoncaWaznosci;
    }

    @NotNull
    @Generated
    public Long getKwota() {
        return this.kwota;
    }

    @Generated
    public @Nullable String getNumerRozliczeniowyBankuZleceniodawcy() {
        return this.numerRozliczeniowyBankuZleceniodawcy;
    }

    @NotNull
    @Generated
    public NRB getRachunekZleceniodawcy() {
        return this.rachunekZleceniodawcy;
    }

    @Generated
    public @Nullable NazwaIAdresZleceniodawcy getNazwaIAdresZleceniodawcy() {
        return this.nazwaIAdresZleceniodawcy;
    }

    @NotNull
    @Generated
    public NazwaIAdresOdbiorcy getNazwaIAdresOdbiorcy() {
        return this.nazwaIAdresOdbiorcy;
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull @Size(max=35) @Pattern(regexp="[^|,\"]*") String> getTytulZlecenia() {
        return this.tytulZlecenia;
    }

    @Generated
    public @Nullable TypWyplaty getTypWyplaty() {
        return this.typWyplaty;
    }

    @NotNull
    @Generated
    public IdentyfikatorKontrahenta getIdentyfikatorKontrahenta() {
        return this.identyfikatorKontrahenta;
    }

    @Generated
    public @Nullable String getKodRekoncyliacji() {
        return this.kodRekoncyliacji;
    }

    @Deprecated
    @Generated
    public @Nullable NRB getKontoAIPP() {
        return this.kontoAIPP;
    }

    @Generated
    public void setKodZlecenia(@NotNull Integer kodZlecenia) {
        this.kodZlecenia = kodZlecenia;
    }

    @Generated
    public void setDataPoczatkuWaznosci(@Nullable LocalDate dataPoczatkuWaznosci) {
        this.dataPoczatkuWaznosci = dataPoczatkuWaznosci;
    }

    @Generated
    public void setDataKoncaWaznosci(@Nullable LocalDate dataKoncaWaznosci) {
        this.dataKoncaWaznosci = dataKoncaWaznosci;
    }

    @Generated
    public void setKwota(@NotNull Long kwota) {
        this.kwota = kwota;
    }

    @Generated
    public void setNumerRozliczeniowyBankuZleceniodawcy(@Nullable String numerRozliczeniowyBankuZleceniodawcy) {
        this.numerRozliczeniowyBankuZleceniodawcy = numerRozliczeniowyBankuZleceniodawcy;
    }

    @Generated
    public void setRachunekZleceniodawcy(@NotNull NRB rachunekZleceniodawcy) {
        this.rachunekZleceniodawcy = rachunekZleceniodawcy;
    }

    @Generated
    public void setNazwaIAdresZleceniodawcy(@Nullable NazwaIAdresZleceniodawcy nazwaIAdresZleceniodawcy) {
        this.nazwaIAdresZleceniodawcy = nazwaIAdresZleceniodawcy;
    }

    @Generated
    public void setNazwaIAdresOdbiorcy(@NotNull NazwaIAdresOdbiorcy nazwaIAdresOdbiorcy) {
        this.nazwaIAdresOdbiorcy = nazwaIAdresOdbiorcy;
    }

    @Generated
    public void setTytulZlecenia(@NotNull @NotNull List<@NotNull @Size(max=35) @Pattern(regexp="[^|,\"]*") String> tytulZlecenia) {
        this.tytulZlecenia = tytulZlecenia;
    }

    @Generated
    public void setTypWyplaty(@Nullable TypWyplaty typWyplaty) {
        this.typWyplaty = typWyplaty;
    }

    @Generated
    public void setIdentyfikatorKontrahenta(@NotNull IdentyfikatorKontrahenta identyfikatorKontrahenta) {
        this.identyfikatorKontrahenta = identyfikatorKontrahenta;
    }

    @Generated
    public void setKodRekoncyliacji(@Nullable String kodRekoncyliacji) {
        this.kodRekoncyliacji = kodRekoncyliacji;
    }

    @Deprecated
    @Generated
    public void setKontoAIPP(@Nullable NRB kontoAIPP) {
        this.kontoAIPP = kontoAIPP;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutowyplataMilleniumZlecenie)) {
            return false;
        }
        AutowyplataMilleniumZlecenie other = (AutowyplataMilleniumZlecenie)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$kodZlecenia = this.getKodZlecenia();
        Integer other$kodZlecenia = other.getKodZlecenia();
        if (this$kodZlecenia == null ? other$kodZlecenia != null : !((Object)this$kodZlecenia).equals(other$kodZlecenia)) {
            return false;
        }
        Long this$kwota = this.getKwota();
        Long other$kwota = other.getKwota();
        if (this$kwota == null ? other$kwota != null : !((Object)this$kwota).equals(other$kwota)) {
            return false;
        }
        LocalDate this$dataPoczatkuWaznosci = this.getDataPoczatkuWaznosci();
        LocalDate other$dataPoczatkuWaznosci = other.getDataPoczatkuWaznosci();
        if (this$dataPoczatkuWaznosci == null ? other$dataPoczatkuWaznosci != null : !((Object)this$dataPoczatkuWaznosci).equals(other$dataPoczatkuWaznosci)) {
            return false;
        }
        LocalDate this$dataKoncaWaznosci = this.getDataKoncaWaznosci();
        LocalDate other$dataKoncaWaznosci = other.getDataKoncaWaznosci();
        if (this$dataKoncaWaznosci == null ? other$dataKoncaWaznosci != null : !((Object)this$dataKoncaWaznosci).equals(other$dataKoncaWaznosci)) {
            return false;
        }
        String this$numerRozliczeniowyBankuZleceniodawcy = this.getNumerRozliczeniowyBankuZleceniodawcy();
        String other$numerRozliczeniowyBankuZleceniodawcy = other.getNumerRozliczeniowyBankuZleceniodawcy();
        if (this$numerRozliczeniowyBankuZleceniodawcy == null ? other$numerRozliczeniowyBankuZleceniodawcy != null : !this$numerRozliczeniowyBankuZleceniodawcy.equals(other$numerRozliczeniowyBankuZleceniodawcy)) {
            return false;
        }
        NRB this$rachunekZleceniodawcy = this.getRachunekZleceniodawcy();
        NRB other$rachunekZleceniodawcy = other.getRachunekZleceniodawcy();
        if (this$rachunekZleceniodawcy == null ? other$rachunekZleceniodawcy != null : !this$rachunekZleceniodawcy.equals(other$rachunekZleceniodawcy)) {
            return false;
        }
        NazwaIAdresZleceniodawcy this$nazwaIAdresZleceniodawcy = this.getNazwaIAdresZleceniodawcy();
        NazwaIAdresZleceniodawcy other$nazwaIAdresZleceniodawcy = other.getNazwaIAdresZleceniodawcy();
        if (this$nazwaIAdresZleceniodawcy == null ? other$nazwaIAdresZleceniodawcy != null : !((Object)this$nazwaIAdresZleceniodawcy).equals(other$nazwaIAdresZleceniodawcy)) {
            return false;
        }
        NazwaIAdresOdbiorcy this$nazwaIAdresOdbiorcy = this.getNazwaIAdresOdbiorcy();
        NazwaIAdresOdbiorcy other$nazwaIAdresOdbiorcy = other.getNazwaIAdresOdbiorcy();
        if (this$nazwaIAdresOdbiorcy == null ? other$nazwaIAdresOdbiorcy != null : !((Object)this$nazwaIAdresOdbiorcy).equals(other$nazwaIAdresOdbiorcy)) {
            return false;
        }
        List<String> this$tytulZlecenia = this.getTytulZlecenia();
        List<String> other$tytulZlecenia = other.getTytulZlecenia();
        if (this$tytulZlecenia == null ? other$tytulZlecenia != null : !((Object)this$tytulZlecenia).equals(other$tytulZlecenia)) {
            return false;
        }
        TypWyplaty this$typWyplaty = this.getTypWyplaty();
        TypWyplaty other$typWyplaty = other.getTypWyplaty();
        if (this$typWyplaty == null ? other$typWyplaty != null : !((Object)((Object)this$typWyplaty)).equals((Object)other$typWyplaty)) {
            return false;
        }
        IdentyfikatorKontrahenta this$identyfikatorKontrahenta = this.getIdentyfikatorKontrahenta();
        IdentyfikatorKontrahenta other$identyfikatorKontrahenta = other.getIdentyfikatorKontrahenta();
        if (this$identyfikatorKontrahenta == null ? other$identyfikatorKontrahenta != null : !((Object)this$identyfikatorKontrahenta).equals(other$identyfikatorKontrahenta)) {
            return false;
        }
        String this$kodRekoncyliacji = this.getKodRekoncyliacji();
        String other$kodRekoncyliacji = other.getKodRekoncyliacji();
        if (this$kodRekoncyliacji == null ? other$kodRekoncyliacji != null : !this$kodRekoncyliacji.equals(other$kodRekoncyliacji)) {
            return false;
        }
        NRB this$kontoAIPP = this.getKontoAIPP();
        NRB other$kontoAIPP = other.getKontoAIPP();
        return !(this$kontoAIPP == null ? other$kontoAIPP != null : !this$kontoAIPP.equals(other$kontoAIPP));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AutowyplataMilleniumZlecenie;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $kodZlecenia = this.getKodZlecenia();
        result = result * 59 + ($kodZlecenia == null ? 43 : ((Object)$kodZlecenia).hashCode());
        Long $kwota = this.getKwota();
        result = result * 59 + ($kwota == null ? 43 : ((Object)$kwota).hashCode());
        LocalDate $dataPoczatkuWaznosci = this.getDataPoczatkuWaznosci();
        result = result * 59 + ($dataPoczatkuWaznosci == null ? 43 : ((Object)$dataPoczatkuWaznosci).hashCode());
        LocalDate $dataKoncaWaznosci = this.getDataKoncaWaznosci();
        result = result * 59 + ($dataKoncaWaznosci == null ? 43 : ((Object)$dataKoncaWaznosci).hashCode());
        String $numerRozliczeniowyBankuZleceniodawcy = this.getNumerRozliczeniowyBankuZleceniodawcy();
        result = result * 59 + ($numerRozliczeniowyBankuZleceniodawcy == null ? 43 : $numerRozliczeniowyBankuZleceniodawcy.hashCode());
        NRB $rachunekZleceniodawcy = this.getRachunekZleceniodawcy();
        result = result * 59 + ($rachunekZleceniodawcy == null ? 43 : $rachunekZleceniodawcy.hashCode());
        NazwaIAdresZleceniodawcy $nazwaIAdresZleceniodawcy = this.getNazwaIAdresZleceniodawcy();
        result = result * 59 + ($nazwaIAdresZleceniodawcy == null ? 43 : ((Object)$nazwaIAdresZleceniodawcy).hashCode());
        NazwaIAdresOdbiorcy $nazwaIAdresOdbiorcy = this.getNazwaIAdresOdbiorcy();
        result = result * 59 + ($nazwaIAdresOdbiorcy == null ? 43 : ((Object)$nazwaIAdresOdbiorcy).hashCode());
        List<String> $tytulZlecenia = this.getTytulZlecenia();
        result = result * 59 + ($tytulZlecenia == null ? 43 : ((Object)$tytulZlecenia).hashCode());
        TypWyplaty $typWyplaty = this.getTypWyplaty();
        result = result * 59 + ($typWyplaty == null ? 43 : ((Object)((Object)$typWyplaty)).hashCode());
        IdentyfikatorKontrahenta $identyfikatorKontrahenta = this.getIdentyfikatorKontrahenta();
        result = result * 59 + ($identyfikatorKontrahenta == null ? 43 : ((Object)$identyfikatorKontrahenta).hashCode());
        String $kodRekoncyliacji = this.getKodRekoncyliacji();
        result = result * 59 + ($kodRekoncyliacji == null ? 43 : $kodRekoncyliacji.hashCode());
        NRB $kontoAIPP = this.getKontoAIPP();
        result = result * 59 + ($kontoAIPP == null ? 43 : $kontoAIPP.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AutowyplataMilleniumZlecenie(kodZlecenia=" + this.getKodZlecenia() + ", dataPoczatkuWaznosci=" + this.getDataPoczatkuWaznosci() + ", dataKoncaWaznosci=" + this.getDataKoncaWaznosci() + ", kwota=" + this.getKwota() + ", numerRozliczeniowyBankuZleceniodawcy=" + this.getNumerRozliczeniowyBankuZleceniodawcy() + ", rachunekZleceniodawcy=" + this.getRachunekZleceniodawcy() + ", nazwaIAdresZleceniodawcy=" + this.getNazwaIAdresZleceniodawcy() + ", nazwaIAdresOdbiorcy=" + this.getNazwaIAdresOdbiorcy() + ", tytulZlecenia=" + this.getTytulZlecenia() + ", typWyplaty=" + (Object)((Object)this.getTypWyplaty()) + ", identyfikatorKontrahenta=" + this.getIdentyfikatorKontrahenta() + ", kodRekoncyliacji=" + this.getKodRekoncyliacji() + ", kontoAIPP=" + this.getKontoAIPP() + ")";
    }
}

