/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.narzedzia;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;

public final class BytesJoiner {
    private final byte[] separator;
    private final Predicate<byte[]> predykat;

    private BytesJoiner(byte[] separator, Predicate<byte[]> predykat) {
        this.separator = Objects.requireNonNull(separator);
        this.predykat = Objects.requireNonNull(predykat);
    }

    public static BytesJoiner on(byte[] separator) {
        return new BytesJoiner(BytesJoiner.copyOf(separator), (Predicate<byte[]>)Predicates.alwaysTrue());
    }

    public BytesJoiner skipEmpty() {
        return new BytesJoiner(this.separator, (Predicate<byte[]>)Predicates.not(BytesJoiner::isEmpty));
    }

    public byte[] join(Iterator<byte[]> parts) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Iterator<byte[]> filtered = this.filter(parts);
        if (filtered.hasNext()) {
            BytesJoiner.append(result, filtered.next());
            while (filtered.hasNext()) {
                BytesJoiner.append(result, this.separator);
                BytesJoiner.append(result, filtered.next());
            }
        }
        return result.toByteArray();
    }

    public byte[] join(Iterable<byte[]> parts) {
        return this.join(parts.iterator());
    }

    public byte[] join(byte[] ... parts) {
        return this.join((Iterator<byte[]>)Iterators.forArray((Object[])parts));
    }

    private Iterator<byte[]> filter(Iterator<byte[]> parts) {
        return Iterators.filter(parts, this.predykat::test);
    }

    private static void append(ByteArrayOutputStream stream, byte[] array) {
        stream.write(array, 0, array.length);
    }

    private static byte[] copyOf(byte[] array) {
        return Arrays.copyOf(array, array.length);
    }

    private static boolean isEmpty(byte[] array) {
        return array.length == 0;
    }
}

