/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.narzedzia;

import java.text.BreakIterator;

public class Wrapper {
    private final int maxLength;

    private Wrapper(int maxLength) {
        this.maxLength = maxLength;
    }

    public static Wrapper maxLength(int maxLength) {
        return new Wrapper(maxLength);
    }

    public String wrap(String text) {
        StringBuilder builder = new StringBuilder();
        BreakIterator iterator = this.iterator(text);
        int position = 0;
        int current = iterator.current();
        int next = iterator.next();
        while (next != -1) {
            if (position + next - current > this.maxLength) {
                if (next - current > this.maxLength) {
                    String head = text.substring(current, current += this.maxLength - position);
                    builder.append(head);
                }
                builder.append("\n");
                position = 0;
            }
            while (current < next - this.maxLength) {
                String body = text.substring(current, current += this.maxLength);
                builder.append(body);
                builder.append("\n");
            }
            int n = current;
            current += next - current;
            String tail = text.substring(n, current);
            builder.append(tail);
            position += tail.length();
            if (tail.endsWith("\n")) {
                position = 0;
            }
            current = iterator.current();
            next = iterator.next();
        }
        return builder.toString();
    }

    private BreakIterator iterator(String text) {
        BreakIterator iterator = BreakIterator.getLineInstance();
        iterator.setText(text);
        return iterator;
    }
}

