/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.serializatory.przekazy;

import com.google.common.base.Verify;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Component;
import pl.topteam.common.util.ExtraLocales;
import pl.topteam.jerzyk.model.przekazy.csv.PrzekazPocztowyCSVPaczka;
import pl.topteam.jerzyk.model.przekazy.csv.PrzekazPocztowyCSVZlecenie;
import pl.topteam.jerzyk.model.przekazy.csv.typy.RodzajAdresu;
import pl.topteam.jerzyk.model.przekazy.csv.typy.RodzajPrzekazu;
import pl.topteam.jerzyk.model.przekazy.csv.typy.Wybor;
import pl.topteam.jerzyk.serializatory.Serializator;

@Component
public class PrzekazPocztowyCSVSerializator
implements Serializator<PrzekazPocztowyCSVPaczka> {
    private static final CSVFormat FORMAT = CSVFormat.DEFAULT.builder().setDelimiter(';').get();
    private static final DecimalFormat KWOTA = new DecimalFormat("0.00");
    private static final String[] KOLUMNY_NAGLOWKA;
    private static final String[] KOLUMNY_PRZEKAZU;

    @Override
    public byte[] serializuj(PrzekazPocztowyCSVPaczka paczka, Charset kodowanie) {
        try {
            StringWriter writer = new StringWriter();
            this.naglowek(paczka, writer);
            this.przekazy(paczka, writer);
            return ((Object)writer).toString().getBytes(kodowanie);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void naglowek(PrzekazPocztowyCSVPaczka paczka, Writer writer) throws IOException {
        try (CSVPrinter printer = new CSVPrinter((Appendable)writer, FORMAT.builder().setHeader(KOLUMNY_NAGLOWKA).get());){
            Verify.verifyNotNull(paczka.getZlecenia());
            printer.printRecord(new Object[]{"2", paczka.getUsluga(), paczka.getEmailNadawcy(), paczka.getTelefonNadawcy(), PrzekazPocztowyCSVSerializator.wybor(paczka.getPowiadomienieSMSOPrzyjeciu()), PrzekazPocztowyCSVSerializator.wybor(paczka.getPowiadomienieEmailOPrzyjeciu()), paczka.getNazwaSkroconaNadawcy(), paczka.getZlecenia().size(), KWOTA.format(this.wartosc(paczka.getZlecenia())), ""});
        }
    }

    private void przekazy(PrzekazPocztowyCSVPaczka paczka, Writer writer) throws IOException {
        try (CSVPrinter printer = new CSVPrinter((Appendable)writer, FORMAT.builder().setHeader(KOLUMNY_PRZEKAZU).get());){
            Verify.verifyNotNull(paczka.getZlecenia());
            for (PrzekazPocztowyCSVZlecenie zlecenie : paczka.getZlecenia()) {
                printer.printRecord(new Object[]{PrzekazPocztowyCSVSerializator.rodzajPrzekazu(zlecenie.getRodzajPrzekazu()), KWOTA.format(zlecenie.getWartosc()), zlecenie.getNazwaAdresata(), PrzekazPocztowyCSVSerializator.rodzajAdresu(zlecenie.getRodzajAdresuAdresata()), zlecenie.getKodPocztowyAdresata(), zlecenie.getMiejscowoscAdresata(), zlecenie.getPocztaAdresata(), zlecenie.getUlicaAdresata(), zlecenie.getNumerDomuAdresata(), zlecenie.getNumerLokaluAdresata(), zlecenie.getNumerSkrytkiAdresata(), zlecenie.getTelefonAdresata(), zlecenie.getEmailAdresata(), PrzekazPocztowyCSVSerializator.wybor(zlecenie.getPotwierdzenieOdbioru()), PrzekazPocztowyCSVSerializator.wybor(zlecenie.getPowiadomienieSMSODoreczeniu()), PrzekazPocztowyCSVSerializator.wybor(zlecenie.getPowiadomienieEmailODoreczeniu()), zlecenie.getKorespodencja(), zlecenie.getKorespodencjaNaPotwierdzeniuOdbioru()});
            }
        }
    }

    private BigDecimal wartosc(List<PrzekazPocztowyCSVZlecenie> zlecenia) {
        return zlecenia.stream().map(PrzekazPocztowyCSVZlecenie::getWartosc).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static String rodzajPrzekazu(@Nullable RodzajPrzekazu rodzajPrzekazu) {
        return rodzajPrzekazu == null ? "" : rodzajPrzekazu.getWartosc();
    }

    private static String rodzajAdresu(@Nullable RodzajAdresu rodzajAdresu) {
        return rodzajAdresu == null ? "" : rodzajAdresu.getWartosc();
    }

    private static String wybor(@Nullable Wybor wybor) {
        return wybor == null ? "" : wybor.getWartosc();
    }

    static {
        KWOTA.setDecimalFormatSymbols(new DecimalFormatSymbols(ExtraLocales.PL));
        KWOTA.setRoundingMode(RoundingMode.UNNECESSARY);
        KOLUMNY_NAGLOWKA = new String[]{"Struktura", "Us\u0142uga", "E-mail nadawcy", "Telefon kom\u00f3rkowy nadawcy", "Powiadomienie SMS o przyj\u0119ciu", "Powiadomienie e-mail o przyj\u0119ciu", "Nazwa skr\u00f3cona nadawcy", "\u0141\u0105czna liczba przekaz\u00f3w", "\u0141\u0105czna warto\u015b\u0107 przekaz\u00f3w", "Przyk\u0142adowa nazwa pliku"};
        KOLUMNY_PRZEKAZU = new String[]{"Rodzaj przekazu", "Warto\u015b\u0107 w PLN", "Nazwa adresata", "Rodzaj adresu adresata", "Kod pocztowy adresata", "Miejscowo\u015b\u0107 adresata", "Poczta adresata", "Ulica adresata", "Numer domu adresata", "Numer lokalu adresata", "Numer skrytki/przegr\u00f3dki adresata", "Telefon kom\u00f3rkowy adresata", "E-mail adresata", "Potwierdzenie odbioru", "Powiadomienie SMS o dor\u0119czeniu/zwrocie", "Powiadomienie e-mail o dor\u0119czeniu/zwrocie", "Korespondencja", "Korespondencja na potwierdzeniu odbioru"};
    }
}

