/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.serializatory.przelewy;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.math.LongMath;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Component;
import pl.topteam.common.primitives.ExtraLongs;
import pl.topteam.jerzyk.model.przelewy.bzwbk.BZWBKPaczka;
import pl.topteam.jerzyk.model.przelewy.bzwbk.BZWBKZlecenie;
import pl.topteam.jerzyk.narzedzia.BytesJoiner;
import pl.topteam.jerzyk.serializatory.Serializator;

@Component
public class BZWBKSerializator
implements Serializator<BZWBKPaczka> {
    private static final long[] WAGI = IntStream.rangeClosed(1, 17).mapToLong(i -> LongMath.pow((long)2L, (int)i)).toArray();
    private static final byte[] SEPARATOR = new byte[]{13, 10};
    private static final BytesJoiner JOINER = BytesJoiner.on(SEPARATOR);
    private static final DateTimeFormatter DATA = DateTimeFormatter.ISO_LOCAL_DATE;

    @Override
    public byte[] serializuj(BZWBKPaczka paczka, Charset kodowanie) {
        Verify.verifyNotNull(paczka.getZlecenia());
        return JOINER.join((Iterable<byte[]>)FluentIterable.from(paczka.getZlecenia()).transform(zlecenie -> this.serializuj((BZWBKZlecenie)zlecenie, kodowanie)));
    }

    @Override
    public byte[] serializuj(BZWBKZlecenie zlecenie, Charset kodowanie) {
        String sumaKontrolna = BZWBKSerializator.sumaKontrolna(zlecenie, kodowanie);
        Verify.verifyNotNull((Object)zlecenie.getNumerRachunkuStronyWN());
        Verify.verifyNotNull((Object)zlecenie.getNumerRachunkuStronyMA());
        Verify.verifyNotNull((Object)zlecenie.getDataWykonaniaOperacji());
        Verify.verifyNotNull((Object)zlecenie.getKwotaPrzelewu());
        return Joiner.on((String)",").join((Object)zlecenie.getNumerPaczki(), (Object)zlecenie.getNumerOperacji(), new Object[]{BZWBKSerializator.tekst(zlecenie.getNumerOddzialuStronyWN()), BZWBKSerializator.tekst(zlecenie.getNumerRachunkuStronyWN().value()), BZWBKSerializator.tekst(zlecenie.getNumerOddzialuStronyMA()), BZWBKSerializator.tekst(zlecenie.getNumerRachunkuStronyMA().value()), BZWBKSerializator.tekst(zlecenie.getNazwaBanku()), BZWBKSerializator.tekst(zlecenie.getTytulOperacji()), BZWBKSerializator.kwota(zlecenie.getKwotaPrzelewu()), BZWBKSerializator.tekst(zlecenie.getKodWaluty()), BZWBKSerializator.tekst(zlecenie.getDaneAdresoweKlienta()), BZWBKSerializator.tekst(zlecenie.getNumerTabeliKursowej()), BZWBKSerializator.tekst(zlecenie.getIdentyfikatorPlatnosci()), BZWBKSerializator.tekst(zlecenie.getTypTansferu()), zlecenie.getKodTypuOperacji(), BZWBKSerializator.tekst(DATA.format(zlecenie.getDataWykonaniaOperacji())), BZWBKSerializator.tekst(zlecenie.getZarezerwowane()), sumaKontrolna}).getBytes(kodowanie);
    }

    private static String tekst(@Nullable String tekst) {
        return '|' + Strings.nullToEmpty((String)tekst) + '|';
    }

    private static String kwota(BigDecimal kwota) {
        return kwota.setScale(2).toPlainString();
    }

    private static String sumaKontrolna(BZWBKZlecenie zlecenie, Charset kodowanie) {
        long[] sums = BZWBKSerializator.polaSumyKontrolnej(zlecenie).stream().map(Object::toString).map(String::trim).map(kodowanie::encode).map(ByteBuffer::array).mapToLong(BZWBKSerializator::sum).toArray();
        long res = ExtraLongs.product((long[])sums, (long[])WAGI);
        return StringUtils.substring((String)Long.toString(res), (int)0, (int)10);
    }

    private static List<?> polaSumyKontrolnej(BZWBKZlecenie zlecenie) {
        return Lists.newArrayList((Object[])new Serializable[]{zlecenie.getNumerPaczki(), zlecenie.getNumerOperacji(), zlecenie.getNumerOddzialuStronyWN(), zlecenie.getNumerRachunkuStronyWN().value(), zlecenie.getNumerOddzialuStronyMA(), zlecenie.getNumerRachunkuStronyMA().value(), Strings.nullToEmpty((String)zlecenie.getNazwaBanku()), zlecenie.getTytulOperacji(), zlecenie.getKwotaPrzelewu().setScale(0, RoundingMode.HALF_UP), zlecenie.getKodWaluty(), zlecenie.getDaneAdresoweKlienta(), Strings.nullToEmpty((String)zlecenie.getNumerTabeliKursowej()), Strings.nullToEmpty((String)zlecenie.getIdentyfikatorPlatnosci()), zlecenie.getTypTansferu(), zlecenie.getKodTypuOperacji(), DATA.format(zlecenie.getDataWykonaniaOperacji()), Strings.nullToEmpty((String)zlecenie.getZarezerwowane())});
    }

    private static long sum(byte[] bytes) {
        long sum = 0L;
        for (byte b : bytes) {
            sum += (long)b;
        }
        return sum;
    }
}

