/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.serializatory.przelewy;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.time.format.DateTimeFormatter;
import org.springframework.stereotype.Component;
import pl.topteam.jerzyk.model.przelewy.citydirect.CityDirectPaczka;
import pl.topteam.jerzyk.model.przelewy.citydirect.CityDirectZlecenie;
import pl.topteam.jerzyk.narzedzia.BytesJoiner;
import pl.topteam.jerzyk.serializatory.Serializator;

@Component
public class CityDirectSerializator
implements Serializator<CityDirectPaczka> {
    private static final DateTimeFormatter DATA = DateTimeFormatter.ofPattern("dd/MM/uu");
    private static final byte[] SEPARATOR = new byte[]{10};
    private static final BytesJoiner JOINER = BytesJoiner.on(SEPARATOR);

    @Override
    public byte[] serializuj(CityDirectPaczka paczka, Charset kodowanie) {
        Verify.verifyNotNull(paczka.getZlecenia());
        return JOINER.join((Iterable<byte[]>)FluentIterable.from(paczka.getZlecenia()).transform(zlecenie -> this.serializuj((CityDirectZlecenie)zlecenie, kodowanie)));
    }

    @Override
    public byte[] serializuj(CityDirectZlecenie zlecenie, Charset kodowanie) {
        return Joiner.on((String)"\n").join((Object)0, (Object)zlecenie.getTypTransakcji(), new Object[]{1, zlecenie.getIdentyfikatorPlatnosci(), 2, zlecenie.getNumerRachunkuObciazanego(), 3, zlecenie.getNumerBankuBeneficjenta(), 4, zlecenie.getNumerRachunkuBeneficjenta().value(), 6, Joiner.on((String)"\n").join(zlecenie.getNazwaIAdresBeneficjenta()), 7, CityDirectSerializator.kwota(zlecenie.getKwota()), 8, DATA.format(zlecenie.getDataWaluty()), 9, Joiner.on((String)"\n").join(zlecenie.getSzczegolyPlatnosci()), -1}).getBytes(kodowanie);
    }

    private static String kwota(BigDecimal kwota) {
        return kwota.setScale(2).toPlainString();
    }
}

