/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.serializatory.przelewy;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import java.nio.charset.Charset;
import java.time.format.DateTimeFormatter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Component;
import pl.topteam.jerzyk.model.przelewy.elixir.ElixirPaczka;
import pl.topteam.jerzyk.model.przelewy.elixir.ElixirZlecenie;
import pl.topteam.jerzyk.narzedzia.BytesJoiner;
import pl.topteam.jerzyk.serializatory.Serializator;

@Component
public class ElixirSerializator
implements Serializator<ElixirPaczka> {
    private static final DateTimeFormatter DATA = DateTimeFormatter.BASIC_ISO_DATE;
    private static final byte[] SEPARATOR = new byte[]{10};
    private static final BytesJoiner JOINER = BytesJoiner.on(SEPARATOR);

    @Override
    public byte[] serializuj(ElixirPaczka paczka, Charset kodowanie) {
        Verify.verifyNotNull(paczka.getZlecenia());
        return JOINER.join((Iterable<byte[]>)FluentIterable.from(paczka.getZlecenia()).transform(zlecenie -> this.serializuj((ElixirZlecenie)zlecenie, kodowanie)));
    }

    @Override
    public byte[] serializuj(ElixirZlecenie zlecenie, Charset kodowanie) {
        return Joiner.on((String)",").join((Object)zlecenie.getTypKomunikatu().getWartosc(), (Object)DATA.format(zlecenie.getDataPlanowanegoWykonaniaZlecen()), new Object[]{zlecenie.getKwotaZleceniaGr(), ElixirSerializator.numer(zlecenie.getNumerRozliczeniowyBankuNadawcy()), ElixirSerializator.numer(zlecenie.getNumerRozliczeniowyBankuOdbiorcy()), ElixirSerializator.tekst(zlecenie.getNumerRachunkuNadawcy().value()), ElixirSerializator.tekst(zlecenie.getNumerRachunkuBeneficjenta().value()), ElixirSerializator.tekst(Joiner.on((String)"|").join(zlecenie.getNazwaRachunkuZleceniodawcy())), ElixirSerializator.tekst(Joiner.on((String)"|").join(zlecenie.getNazwaRachunkuBeneficjenta())), ElixirSerializator.numer(zlecenie.getNumerNadawcyUczestnikaPosredniego()), ElixirSerializator.numer(zlecenie.getNumerOddzialuFinalnyAdresat()), ElixirSerializator.tekst(Joiner.on((String)"|").join(zlecenie.getReferencja())), ElixirSerializator.tekst(zlecenie.getNumerCzeku()), ElixirSerializator.tekst(zlecenie.getSzczegolyReklamacji()), ElixirSerializator.tekst(zlecenie.getTypDokumentu().getWartosc()), ElixirSerializator.tekst(zlecenie.getInformacjeMiedzybankowe())}).getBytes(kodowanie);
    }

    private static String numer(@Nullable String numer) {
        return Strings.nullToEmpty((String)numer);
    }

    private static String tekst(@Nullable String tekst) {
        return '\"' + Strings.nullToEmpty((String)tekst) + '\"';
    }
}

