/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.serializatory.przelewy;

import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.prowidesoftware.swift.model.mt.mt1xx.MT103;
import java.nio.charset.Charset;
import org.springframework.stereotype.Component;
import pl.topteam.jerzyk.model.przelewy.mt103.MT103Paczka;
import pl.topteam.jerzyk.narzedzia.BytesJoiner;
import pl.topteam.jerzyk.serializatory.Serializator;

@Component
public class MT103Serializator
implements Serializator<MT103Paczka> {
    private static final byte[] SEPARATOR = new byte[]{36};
    private static final BytesJoiner JOINER = BytesJoiner.on(SEPARATOR);

    @Override
    public byte[] serializuj(MT103Paczka paczka, Charset kodowanie) {
        Verify.verifyNotNull(paczka.getZlecenia());
        return JOINER.join((Iterable<byte[]>)FluentIterable.from(paczka.getZlecenia()).transform(zlecenie -> this.serializuj((MT103)zlecenie, kodowanie)));
    }

    @Override
    public byte[] serializuj(MT103 zlecenie, Charset kodowanie) {
        return zlecenie.message().getBytes(kodowanie);
    }
}

