/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.serializatory.przelewy;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import java.nio.charset.Charset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Component;
import pl.topteam.jerzyk.model.przelewy.multicash.MultiCashPaczka;
import pl.topteam.jerzyk.model.przelewy.multicash.MultiCashZlecenie;
import pl.topteam.jerzyk.model.przelewy.multicash.typy.NazwaIAdres;
import pl.topteam.jerzyk.narzedzia.BytesJoiner;
import pl.topteam.jerzyk.serializatory.Serializator;

@Component
public class MultiCashSerializator
implements Serializator<MultiCashPaczka> {
    private static final DateTimeFormatter DATA = DateTimeFormatter.BASIC_ISO_DATE;
    private static final byte[] SEPARATOR = new byte[]{10};
    private static final BytesJoiner JOINER = BytesJoiner.on(SEPARATOR);

    @Override
    public byte[] serializuj(MultiCashPaczka paczka, Charset kodowanie) {
        Verify.verifyNotNull(paczka.getZlecenia());
        return JOINER.join((Iterable<byte[]>)FluentIterable.from(paczka.getZlecenia()).transform(zlecenie -> this.serializuj((MultiCashZlecenie)zlecenie, kodowanie)));
    }

    @Override
    public byte[] serializuj(MultiCashZlecenie zlecenie, Charset kodowanie) {
        return Joiner.on((String)",").join((Object)zlecenie.getTyp().getWartosc(), (Object)DATA.format(zlecenie.getData()), new Object[]{zlecenie.getKwotaGr(), zlecenie.getNumerOddzialu(), zlecenie.getNumerBankuPosrednika1(), MultiCashSerializator.tekst(zlecenie.getNumerRachunkuKlienta().value()), MultiCashSerializator.tekst(zlecenie.getNumerRachunkuBeneficjenta().value()), MultiCashSerializator.nazwaIAdres(zlecenie.getNazwaKlienta()), MultiCashSerializator.nazwaIAdres(zlecenie.getNazwaBeneficjenta()), zlecenie.getNumerBankuPosrednika2(), zlecenie.getNumerOddzialuBeneficjenta(), MultiCashSerializator.tekst(Joiner.on((String)"|").join(zlecenie.getKomentarz())), MultiCashSerializator.tekst(zlecenie.getNumerCzeku()), MultiCashSerializator.tekst(zlecenie.getIdentyfiaktor()), MultiCashSerializator.tekst(zlecenie.getParametr().getWartosc())}).getBytes(kodowanie);
    }

    private static String nazwaIAdres(NazwaIAdres nazwaIAdres) {
        Verify.verifyNotNull(nazwaIAdres.getNazwa());
        Verify.verifyNotNull(nazwaIAdres.getAdres());
        List<String> nazwa = MultiCashSerializator.resize(nazwaIAdres.getNazwa(), 2);
        List<String> adres = MultiCashSerializator.resize(nazwaIAdres.getAdres(), 2);
        return MultiCashSerializator.tekst(Stream.concat(nazwa.stream(), adres.stream()).collect(Collectors.joining("|")));
    }

    private static List<String> resize(List<String> lista, int size) {
        while (lista.size() < size) {
            lista.add("");
        }
        return lista;
    }

    private static String tekst(@Nullable String tekst) {
        return '\"' + Strings.nullToEmpty((String)tekst) + '\"';
    }
}

