/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.serializatory.przelewy;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import org.springframework.stereotype.Component;
import pl.topteam.jerzyk.model.przelewy.videotel.VideoTELPaczka;
import pl.topteam.jerzyk.model.przelewy.videotel.VideoTELZlecenie;
import pl.topteam.jerzyk.narzedzia.BytesJoiner;
import pl.topteam.jerzyk.serializatory.Serializator;

@Component
public class VideoTELSerializator
implements Serializator<VideoTELPaczka> {
    private static final byte[] SEPARATOR = new byte[]{10};
    private static final BytesJoiner JOINER = BytesJoiner.on(SEPARATOR);

    @Override
    public byte[] serializuj(VideoTELPaczka paczka, Charset kodowanie) {
        Verify.verifyNotNull(paczka.getZlecenia());
        return JOINER.join((Iterable<byte[]>)FluentIterable.from(paczka.getZlecenia()).transform(zlecenie -> this.serializuj((VideoTELZlecenie)zlecenie, kodowanie)));
    }

    @Override
    public byte[] serializuj(VideoTELZlecenie zlecenie, Charset kodowanie) {
        return Joiner.on((String)" ").join((Object)VideoTELSerializator.tekst(zlecenie.getNazwaBankuBeneficjenta()), (Object)VideoTELSerializator.tekst(Joiner.on((String)"???").join(zlecenie.getNazwaRachunkuBeneficjenta())), new Object[]{VideoTELSerializator.tekst(zlecenie.getNumerRachunkuBeneficjenta().value()), VideoTELSerializator.numer(zlecenie.getRezerwowe()), VideoTELSerializator.kwota(zlecenie.getKwotaZlecenia()), VideoTELSerializator.tekst(zlecenie.getNazwaBankuZleceniodawcy()), VideoTELSerializator.tekst(Joiner.on((String)"???").join(zlecenie.getNazwaRachunkuZleceniodawcy())), VideoTELSerializator.tekst(zlecenie.getNumerRachunkuZleceniodawcy().value()), VideoTELSerializator.tekst(Joiner.on((String)"???").join(zlecenie.getReferencja())), VideoTELSerializator.tekst(zlecenie.getWalutaPrzelewu()), VideoTELSerializator.tekst(zlecenie.getNazwaSkroconaBeneficjenta()), VideoTELSerializator.tekst(Joiner.on((String)"???").join(zlecenie.getDomyslnaNazwaRachunkowPowiazanychZDanaFirmaNF())), VideoTELSerializator.tekst(zlecenie.getRodzajWlasnosciFirmyNF().getWartosc()), VideoTELSerializator.tekst(zlecenie.getSygnaturaSystemuFinansowoOksiegowego())}).getBytes(kodowanie);
    }

    private static String numer(Integer numer) {
        return numer != null ? numer.toString() : "";
    }

    private static String tekst(String tekst) {
        return '\"' + Strings.nullToEmpty((String)tekst) + '\"';
    }

    private static String kwota(BigDecimal kwota) {
        return kwota.setScale(2).toPlainString();
    }
}

