/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.serializatory.wyplaty;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Streams;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.List;
import org.springframework.stereotype.Component;
import pl.topteam.jerzyk.model.wyplaty.ing.AutowyplataINGPaczka;
import pl.topteam.jerzyk.model.wyplaty.ing.AutowyplataINGZlecenie;
import pl.topteam.jerzyk.narzedzia.BytesJoiner;
import pl.topteam.jerzyk.serializatory.Serializator;

@Component
public class AutowyplataINGSerializator
implements Serializator<AutowyplataINGPaczka> {
    private static final byte[] SEPARATOR = new byte[]{13, 10};
    private static final BytesJoiner JOINER = BytesJoiner.on(SEPARATOR);

    @Override
    public byte[] serializuj(AutowyplataINGPaczka paczka, Charset kodowanie) {
        Verify.verifyNotNull((Object)((Object)paczka.getFlaga()));
        Verify.verifyNotNull((Object)paczka.getIDKlienta());
        Verify.verifyNotNull((Object)paczka.getIDPliku());
        Verify.verifyNotNull(paczka.getZlecenia());
        byte[] naglowek = Joiner.on((String)";").join((Object)AutowyplataINGSerializator.tekst(paczka.getFlaga().getWartosc()), (Object)AutowyplataINGSerializator.tekst(paczka.getIDKlienta()), new Object[]{AutowyplataINGSerializator.tekst(paczka.getIDPliku()), AutowyplataINGSerializator.ilosc(paczka.getZlecenia()), this.wartosc(paczka.getZlecenia())}).getBytes(kodowanie);
        byte[][] zlecenia = (byte[][])Streams.mapWithIndex(paczka.getZlecenia().stream(), (zlecenie, indeks) -> this.serializuj((AutowyplataINGZlecenie)Verify.verifyNotNull((Object)zlecenie), kodowanie, indeks + 1L)).toArray(x$0 -> new byte[x$0][]);
        return JOINER.join((Iterable<byte[]>)FluentIterable.of((Object)naglowek, (Object[])new byte[0][]).append((Object[])zlecenia));
    }

    public byte[] serializuj(AutowyplataINGZlecenie zlecenie, Charset kodowanie, long numer) {
        return Joiner.on((String)";").join((Object)Strings.padStart((String)Long.toString(numer), (int)4, (char)'0'), (Object)AutowyplataINGSerializator.tekst(zlecenie.getTypOsoby().getWartosc()), new Object[]{AutowyplataINGSerializator.tekst(zlecenie.getPesel().value()), AutowyplataINGSerializator.tekst(zlecenie.getDokumentTozsamosci()), zlecenie.getRachunek().value(), AutowyplataINGSerializator.kwota(zlecenie.getKwota()), AutowyplataINGSerializator.tekst(zlecenie.getWaluta()), AutowyplataINGSerializator.tekst(zlecenie.getTytul()), AutowyplataINGSerializator.tekst(zlecenie.getSygnatura()), AutowyplataINGSerializator.tekst(zlecenie.getDataOd().toString()), AutowyplataINGSerializator.tekst(zlecenie.getDataDo().toString()), AutowyplataINGSerializator.tekst(zlecenie.getDanePersonalne()), AutowyplataINGSerializator.tekst(zlecenie.getAdres())}).getBytes(kodowanie);
    }

    private static String ilosc(List<AutowyplataINGZlecenie> zlecenia) {
        return Integer.toString(zlecenia.size());
    }

    private String wartosc(List<AutowyplataINGZlecenie> zlecenia) {
        return zlecenia.stream().map(AutowyplataINGZlecenie::getKwota).reduce(BigDecimal.ZERO, BigDecimal::add).toPlainString();
    }

    private static String tekst(String tekst) {
        return "\"" + Strings.nullToEmpty((String)tekst) + "\"";
    }

    private static String kwota(BigDecimal kwota) {
        return kwota.setScale(2).toPlainString();
    }
}

