/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.serializatory.wyplaty;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Component;
import pl.topteam.common.format.kontakty.TelefonPrinter;
import pl.topteam.common.model.kontakty.Telefon;
import pl.topteam.common.util.ExtraLocales;
import pl.topteam.jerzyk.model.wyplaty.mikrus.AutowyplataMikrusPaczka;
import pl.topteam.jerzyk.model.wyplaty.mikrus.AutowyplataMikrusZlecenie;
import pl.topteam.jerzyk.narzedzia.BytesJoiner;
import pl.topteam.jerzyk.serializatory.Serializator;

@Component
public class AutowyplataMikrusSerializator
implements Serializator<AutowyplataMikrusPaczka> {
    private static final byte[] SEPARATOR = new byte[]{13, 10};
    private static final BytesJoiner JOINER = BytesJoiner.on(SEPARATOR);
    private static final DecimalFormat KWOTA = new DecimalFormat("0.00");
    private static final TelefonPrinter TELEFON;

    @Override
    public byte[] serializuj(AutowyplataMikrusPaczka paczka, Charset kodowanie) {
        Verify.verifyNotNull(paczka.getZlecenia());
        return JOINER.join((Iterable<byte[]>)FluentIterable.from(paczka.getZlecenia()).transform(zlecenie -> this.serializuj((AutowyplataMikrusZlecenie)zlecenie, kodowanie)));
    }

    @Override
    public byte[] serializuj(AutowyplataMikrusZlecenie zlecenie, Charset kodowanie) {
        return Joiner.on((String)";").useForNull("").join((Object)zlecenie.getImieNazwisko().split(" ", 2)[0], (Object)zlecenie.getImieNazwisko().split(" ", 2)[1], new Object[]{zlecenie.getUlicaDomLokal(), zlecenie.getMiejscowosc(), zlecenie.getTytulPlatnosci(), KWOTA.format(zlecenie.getKwota()), zlecenie.getTypIdentyfikatora().getWartosc(), zlecenie.getIdentyfikator(), this.print(zlecenie.getTelefon())}).getBytes(kodowanie);
    }

    private String print(@Nullable Telefon telefon) {
        return telefon != null ? TELEFON.print(telefon, ExtraLocales.PL) : "";
    }

    static {
        KWOTA.setDecimalFormatSymbols(new DecimalFormatSymbols(ExtraLocales.PL));
        KWOTA.setRoundingMode(RoundingMode.UNNECESSARY);
        TELEFON = new TelefonPrinter();
    }
}

