/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.serializatory.wyplaty;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Component;
import pl.topteam.common.model.NRB;
import pl.topteam.jerzyk.model.wyplaty.millenium.AutowyplataMilleniumPaczka;
import pl.topteam.jerzyk.model.wyplaty.millenium.AutowyplataMilleniumZlecenie;
import pl.topteam.jerzyk.model.wyplaty.millenium.typy.IdentyfikatorKontrahenta;
import pl.topteam.jerzyk.model.wyplaty.millenium.typy.NazwaIAdresOdbiorcy;
import pl.topteam.jerzyk.model.wyplaty.millenium.typy.NazwaIAdresZleceniodawcy;
import pl.topteam.jerzyk.model.wyplaty.millenium.typy.TypWyplaty;
import pl.topteam.jerzyk.narzedzia.BytesJoiner;
import pl.topteam.jerzyk.serializatory.Serializator;

@Component
public class AutowyplataMilleniumSerializator
implements Serializator<AutowyplataMilleniumPaczka> {
    private static final DateTimeFormatter DATA = DateTimeFormatter.BASIC_ISO_DATE;
    private static final byte[] SEPARATOR = new byte[]{13, 10};
    private static final BytesJoiner JOINER = BytesJoiner.on(SEPARATOR);

    @Override
    public byte[] serializuj(AutowyplataMilleniumPaczka paczka, Charset kodowanie) {
        Verify.verifyNotNull(paczka.getZlecenia());
        return JOINER.join((Iterable<byte[]>)FluentIterable.from(paczka.getZlecenia()).transform(zlecenie -> this.serializuj((AutowyplataMilleniumZlecenie)zlecenie, kodowanie)));
    }

    @Override
    public byte[] serializuj(AutowyplataMilleniumZlecenie zlecenie, Charset kodowanie) {
        return Joiner.on((String)",").join((Object)zlecenie.getKodZlecenia(), (Object)AutowyplataMilleniumSerializator.data(zlecenie.getDataPoczatkuWaznosci()), new Object[]{AutowyplataMilleniumSerializator.data(zlecenie.getDataKoncaWaznosci()), zlecenie.getKwota(), AutowyplataMilleniumSerializator.numer(zlecenie.getNumerRozliczeniowyBankuZleceniodawcy()), AutowyplataMilleniumSerializator.konto(zlecenie.getRachunekZleceniodawcy()), AutowyplataMilleniumSerializator.nazwaIAdresZleceniodawcy(zlecenie.getNazwaIAdresZleceniodawcy()), AutowyplataMilleniumSerializator.nazwaIAdresOdbiorcy(zlecenie.getNazwaIAdresOdbiorcy()), AutowyplataMilleniumSerializator.tekst(zlecenie.getTytulZlecenia()), this.typWyplaty(zlecenie.getTypWyplaty()), AutowyplataMilleniumSerializator.IDKontrahenta(zlecenie.getIdentyfikatorKontrahenta()), AutowyplataMilleniumSerializator.tekst(zlecenie.getKodRekoncyliacji()), AutowyplataMilleniumSerializator.konto(zlecenie.getKontoAIPP())}).getBytes(kodowanie);
    }

    private static String data(LocalDate data) {
        String res = data == null ? "" : DATA.format(data);
        return res;
    }

    private static String konto(NRB nrb) {
        String res = nrb == null ? "" : nrb.value();
        return AutowyplataMilleniumSerializator.tekst(res);
    }

    private static String tekst(List<String> nazwa) {
        return AutowyplataMilleniumSerializator.tekst(Joiner.on((String)"|").join(nazwa));
    }

    private static String nazwaIAdresZleceniodawcy(NazwaIAdresZleceniodawcy nazwaIAdres) {
        return nazwaIAdres == null ? AutowyplataMilleniumSerializator.tekst("") : AutowyplataMilleniumSerializator.tekst(FluentIterable.from(nazwaIAdres.getNazwa()).append((Object[])new String[]{nazwaIAdres.getUlica()}).append((Object[])new String[]{nazwaIAdres.getKodPocztowy()}).append((Object[])new String[]{nazwaIAdres.getMiejscowosc()}).join(Joiner.on((String)"|")));
    }

    private static String nazwaIAdresOdbiorcy(NazwaIAdresOdbiorcy nazwaIAdres) {
        return AutowyplataMilleniumSerializator.tekst(FluentIterable.from(nazwaIAdres.getNazwa()).append((Object[])new String[]{nazwaIAdres.getUlica()}).append((Object[])new String[]{nazwaIAdres.getKodPocztowy()}).append((Object[])new String[]{nazwaIAdres.getMiejscowosc()}).join(Joiner.on((String)"|")));
    }

    private static String numer(@Nullable String numer) {
        return Strings.nullToEmpty((String)numer);
    }

    private static String tekst(@Nullable String tekst) {
        return '\"' + Strings.nullToEmpty((String)tekst) + '\"';
    }

    private static String IDKontrahenta(IdentyfikatorKontrahenta idKontrahenta) {
        return AutowyplataMilleniumSerializator.tekst(Joiner.on((String)"|").join((Object)idKontrahenta.getTyp().getWartosc(), (Object)idKontrahenta.getNumer(), new Object[0]));
    }

    private int typWyplaty(@Nullable TypWyplaty typWyplaty) {
        return typWyplaty == null ? 0 : typWyplaty.getWartosc();
    }
}

