/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.serializatory.wyplaty;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import java.nio.charset.Charset;
import java.time.format.DateTimeFormatter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Component;
import pl.topteam.jerzyk.model.wyplaty.pekao.AutowyplataPekaoPaczka;
import pl.topteam.jerzyk.model.wyplaty.pekao.AutowyplataPekaoZlecenie;
import pl.topteam.jerzyk.model.wyplaty.pekao.typy.DaneBeneficjenta;
import pl.topteam.jerzyk.model.wyplaty.pekao.typy.DokumentTozsamosci;
import pl.topteam.jerzyk.narzedzia.BytesJoiner;
import pl.topteam.jerzyk.serializatory.Serializator;

@Component
public class AutowyplataPekaoSerializator
implements Serializator<AutowyplataPekaoPaczka> {
    private static final DateTimeFormatter DATA = DateTimeFormatter.BASIC_ISO_DATE;
    private static final byte[] SEPARATOR = new byte[]{13, 10};
    private static final BytesJoiner JOINER = BytesJoiner.on(SEPARATOR);

    @Override
    public byte[] serializuj(AutowyplataPekaoPaczka paczka, Charset kodowanie) {
        Verify.verifyNotNull(paczka.getZlecenia());
        return JOINER.join((Iterable<byte[]>)FluentIterable.from(paczka.getZlecenia()).transform(zlecenie -> this.serializuj((AutowyplataPekaoZlecenie)zlecenie, kodowanie)));
    }

    @Override
    public byte[] serializuj(AutowyplataPekaoZlecenie zlecenie, Charset kodowanie) {
        return Joiner.on((String)",").join((Object)"110", (Object)DATA.format(zlecenie.getDataRealizacji()), new Object[]{zlecenie.getKwotaZleceniaGr(), zlecenie.getNumerRozliczeniowy(), "0", zlecenie.getNumerRachunku().value(), "0", AutowyplataPekaoSerializator.tekst(Joiner.on((String)"|").join(zlecenie.getDaneZleceniodawcy())), AutowyplataPekaoSerializator.daneBeneficjenta(zlecenie.getDaneBeneficjenta()), DATA.format(zlecenie.getDataKoncowa()), "0", AutowyplataPekaoSerializator.tekst(Joiner.on((String)"|").join(zlecenie.getTytulem())), zlecenie.getTrybRealizacji().getWartosc(), AutowyplataPekaoSerializator.typDokumentuTozsamosci(zlecenie.getDokumentTozsamosci()), AutowyplataPekaoSerializator.tekst("55"), AutowyplataPekaoSerializator.tekst(zlecenie.getSygnaturaZlecenia())}).getBytes(kodowanie);
    }

    private static String daneBeneficjenta(DaneBeneficjenta daneBeneficjenta) {
        return AutowyplataPekaoSerializator.tekst(FluentIterable.from(daneBeneficjenta.getNazwa()).append((Object[])new String[]{daneBeneficjenta.getUlica()}).append((Object[])new String[]{daneBeneficjenta.getKod()}).append((Object[])new String[]{daneBeneficjenta.getMiejscowosc()}).join(Joiner.on((String)"|")));
    }

    private static String typDokumentuTozsamosci(DokumentTozsamosci typDokumentuTozsamosci) {
        return AutowyplataPekaoSerializator.tekst(Joiner.on((String)"||").join((Object)typDokumentuTozsamosci.getTyp().getWartosc(), (Object)typDokumentuTozsamosci.getNumer(), new Object[0]));
    }

    private static String tekst(@Nullable String tekst) {
        return "\"" + Strings.nullToEmpty((String)tekst) + "\"";
    }
}

