/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.jerzyk.walidatory.pattern;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MTPatternCompiler {
    private static final Pattern RESTRICTION = Pattern.compile("([0-9]+|[0-9]+!|[0-9]+-[0-9]+)([nachxyzde])");
    private static final Map<String, String> CHARS = ImmutableMap.builder().put((Object)"n", (Object)"[0-9]").put((Object)"a", (Object)"[\\p{Lu}]").put((Object)"c", (Object)"[\\p{Lu}0-9]").put((Object)"h", (Object)"[A-F0-9]").put((Object)"x", (Object)"[\\p{L}0-9/\\-?:().,'+ ]").put((Object)"y", (Object)"[\\p{Lu}0-9.,\\-()/='+:?!\"%&*<>; ]").put((Object)"z", (Object)"[\\p{L}0-9.,\\-()/='+:?!\"%&*<>;{@#_ ]").put((Object)"e", (Object)" ").build();

    public static Pattern compile(String pattern) {
        String regex = MTPatternCompiler.regex(pattern);
        return Pattern.compile(regex);
    }

    private static String regex(String pattern) {
        StringBuffer buffer = new StringBuffer();
        pattern = MTPatternCompiler.fixBrackets(pattern);
        Matcher matcher = RESTRICTION.matcher(pattern);
        while (matcher.find()) {
            String cardinality = matcher.group(1);
            String characters = matcher.group(2);
            String replacement = MTPatternCompiler.replacement(cardinality, characters);
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static String replacement(String cardinality, String characters) {
        ContiguousSet<Integer> _cardinality = MTPatternCompiler.cardinality(cardinality);
        String _characters = CHARS.get(characters);
        return characters.equals("d") ? MTPatternCompiler.amount(_cardinality) : MTPatternCompiler.chars(Objects.requireNonNull(_cardinality), Objects.requireNonNull(_characters));
    }

    private static String chars(ContiguousSet<Integer> cardinality, String characters) {
        return characters + "{" + cardinality.first() + "," + cardinality.last() + "}";
    }

    private static String amount(ContiguousSet<Integer> cardinality) {
        int lower = (Integer)cardinality.first();
        int upper = (Integer)cardinality.last();
        Preconditions.checkArgument((lower >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((upper >= 2 ? 1 : 0) != 0);
        return IntStream.range(1, upper).mapToObj(i -> String.format("([0-9]{%d},[0-9]{%d,%d})", i, Math.max(0, lower - i - 1), Math.max(0, upper - i - 1))).collect(Collectors.joining("|", "(", ")"));
    }

    private static ContiguousSet<Integer> cardinality(String cardinality) {
        if (cardinality.matches("[0-9]+")) {
            int upper = Integer.parseInt(cardinality);
            return ContiguousSet.closed((int)1, (int)upper);
        }
        if (cardinality.matches("[0-9]+!")) {
            int exact = Integer.parseInt(cardinality.replace("!", ""));
            return ContiguousSet.closed((int)exact, (int)exact);
        }
        if (cardinality.matches("[0-9]+-[0-9]+")) {
            int lower = Integer.parseInt((String)Splitter.on((String)"-").splitToList((CharSequence)cardinality).get(0));
            int upper = Integer.parseInt((String)Splitter.on((String)"-").splitToList((CharSequence)cardinality).get(1));
            return ContiguousSet.closed((int)lower, (int)upper);
        }
        throw new IllegalArgumentException();
    }

    private static String fixBrackets(String string) {
        return string.replace("[", "(").replace("]", ")?");
    }
}

