<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns2="http://mpips.gov.pl/xsd/csizs/cbb/typy/v2"
                xmlns:ns4="http://mpips.gov.pl/xsd/csizs/typy/v2"
                xmlns:date="http://exslt.org/dates-and-times">

    <xsl:decimal-format grouping-separator="." decimal-separator="," NaN=""/>

    <xsl:key name="czlonekRodziny" match="czlonekRodziny" use="opisOsoby/wyroznik/idOsobySD"/>

    <xsl:template match="/" name="kOdpUdostepnijDane">

        <xsl:variable name="NiebieskaKarta" select="document('../../../../../../../../xml/NiebieskaKarta.xml')/properties/entry" />
        <xsl:variable name="KodLokalizacji" select="document('../../../../../../../../xml/KodLokalizacji.xml')/properties/entry" />
        <xsl:variable name="KodNTS" select="document('../../../../../../../../xml/KodNTS.xml')/properties/entry" />
        <xsl:variable name="KodNUTS" select="document('../../../../../../../../xml/KodNUTS.xml')/properties/entry" />
        <xsl:variable name="JednostkaBiezacaKod" select="//naglowek/ns2:wyroznikSD/ns2:jednostkaTerenowaKod"/>

        <div class="odpowiedz">

            <xsl:for-each select="//wynikPobraniaTozsamosciSzczeg/tozsamosc/osoby/osoba">
                <table>
                    <caption>Dane osobowe</caption>
                    <tr>
                        <td colspan="2" class="label">Ośrodek:</td>
                        <td colspan="2">
                            <xsl:variable name="_KodLokalizacjiLubNTS" select="wyroznik/wyroznikSD/ns2:jednostkaTerenowaKod" />
                            <xsl:if test="$KodLokalizacji[@key = $_KodLokalizacjiLubNTS]">
                                JEDNOSTKA: <b><xsl:value-of select="$KodLokalizacji[@key = $_KodLokalizacjiLubNTS]" /></b>
                            </xsl:if>
                            <xsl:if test="$KodNTS[@key = $_KodLokalizacjiLubNTS]">
                                JEDNOSTKA: <b><xsl:value-of select="$KodNTS[@key = $_KodLokalizacjiLubNTS]" /></b>
                            </xsl:if>
                            <xsl:if test="$KodNUTS[@key = $_KodLokalizacjiLubNTS]">
                                JEDNOSTKA: <b><xsl:value-of select="$KodNUTS[@key = $_KodLokalizacjiLubNTS]" /></b>
                            </xsl:if>
                            OBSZAR: <b><xsl:value-of select="wyroznik/wyroznikSD/ns2:obszarZabezpieczeniaSpolecznegoKod"/></b>
                            KOD: <b><xsl:value-of select="$_KodLokalizacjiLubNTS"/></b>
                            <xsl:if test="wyroznik/wyroznikSD/ns2:jednostkaTerenowaKod = $JednostkaBiezacaKod">
                                <b> (bieżąca jednostka)</b>
                            </xsl:if>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Nazwisko</td>
                        <td><xsl:value-of select="dane/nazwisko"/></td>
                        <td class="label">Imię</td>
                        <td><xsl:value-of select="dane/imie"/></td>
                    </tr>
                    <tr>
                        <td class="label">Imię drugie</td>
                        <td><xsl:value-of select="dane/imieDrugie"/></td>
                        <td class="label">Data urodzenia</td>
                        <td><xsl:value-of select="dane/dataUrodzenia"/></td>
                    </tr>
                    <tr>
                        <td class="label">Pesel</td>
                        <td><xsl:value-of select="dane/pesel"/></td>
                        <td class="label">Nr cudzoziemca</td>
                        <td><xsl:value-of select="dane/nrCudzoziemca"/></td>
                    </tr>
                    <tr>
                        <td class="label">Imię matki</td>
                        <td><xsl:value-of select="dane/imieMatki"/></td>
                        <td class="label">Imię ojca</td>
                        <td><xsl:value-of select="dane/imieOjca"/></td>
                    </tr>
                    <tr>
                        <td class="label">Nazwisko drugie</td>
                        <td><xsl:value-of select="dane/nazwiskoDrugie"/></td>
                        <td class="label">Nazwisko panieńskie</td>
                        <td><xsl:value-of select="dane/nazwiskoPanienskie"/></td>
                    </tr>
                    <tr>
                        <td class="label">Obywatelstwo</td>
                        <td><xsl:value-of select="dane/obywatelstwo/ns4:wartosc"/></td>
                        <td class="label"></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td class="label">Płeć</td>
                        <td><xsl:value-of select="dane/plec/ns4:wartosc"/></td>
                        <td class="label">Stan cywilny</td>
                        <td><xsl:value-of select="dane/stanCywilny/ns4:wartosc"/></td>
                    </tr>
                    <tr>
                        <td class="label">Niebieska karta</td>
                        <td>
                            <xsl:variable name="_NiebieskaKarta" select="dane/niebieskaKarta" />
                            <xsl:value-of select="$NiebieskaKarta[@key = $_NiebieskaKarta]" />
                        </td>
                        <td class="label">Alimenty</td>
                        <td><xsl:value-of select="dane/alimenty"/></td>
                    </tr>
                    <tr>
                        <td class="label">Rodzaj szkoły</td>
                        <td><xsl:value-of select="dane/rodzajSzkoly/ns4:wartosc"/></td>
                        <td class="label">Beneficjent</td>
                        <td>
                            <xsl:choose>
                                <xsl:when test="dane/beneficjent = 'true'">
                                    beneficjent
                                </xsl:when>
                                <xsl:otherwise>
                                    członek rodziny lub inna osoba powiązana z beneficjentem
                                </xsl:otherwise>
                            </xsl:choose>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Rodzaj beneficjenta</td>
                        <td><xsl:value-of select="dane/rodzajBeneficjenta/ns4:wartosc"/></td>
                        <td class="label"></td>
                        <td></td>
                    </tr>
                </table>
                <xsl:for-each select="daneAdresowe">
                    <table>
                        <caption>Dane adresowe</caption>
                        <tr>
                            <td class="label">Kraj</td>
                            <td><xsl:value-of select="dane/kraj/ns4:wartosc"/></td>
                            <td class="label">Kod pocztowy</td>
                            <td><xsl:value-of select="dane/kodPocztowy"/></td>
                        </tr>
                        <tr>
                            <td class="label">Miejscowość</td>
                            <td><xsl:value-of select="dane/miejscowosc"/></td>
                            <td class="label">Ulica</td>
                            <td><xsl:value-of select="dane/ulica"/></td>
                        </tr>
                        <tr>
                            <td class="label">Nr domu</td>
                            <td><xsl:value-of select="dane/nrDomu"/></td>
                            <td class="label">Nr lokalu</td>
                            <td><xsl:value-of select="dane/nrLokalu"/></td>
                        </tr>
                        <tr>
                            <td class="label">Inny kod pocztowy</td>
                            <td><xsl:value-of select="dane/kodPocztowyInny"/></td>
                            <td class="label"></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="label">Adres e-mail</td>
                            <td><xsl:value-of select="dane/adresEmail"/></td>
                            <td class="label"></td>
                            <td></td>
                        </tr>
                    </table>
                </xsl:for-each>

                <xsl:for-each select="dokumentTozsamosci">
                    <table>
                        <caption>Dane dokumentu tożsamości</caption>
                        <tr>
                            <td class="label">Seria i numer</td>
                            <td><xsl:value-of select="wyroznik/seriaNumer"/></td>
                            <td class="label">Rodzaj dokumentu</td>
                            <td><xsl:value-of select="wyroznik/rodzajDokumentu/ns4:wartosc"/></td>
                        </tr>
                    </table>
                </xsl:for-each>

                <xsl:for-each select="rodzina">
                    <table>
                        <caption>Dane rodziny</caption>
                        <th class="label">Nazwisko</th>
                        <th class="label">Imię</th>
                        <th class="label">Data ur.</th>
                        <th class="label">Pokrewieństwo</th>
                        <th class="label">Rodzaj osoby</th>
                        <xsl:for-each select="czlonekRodziny">
                            <tr>
                                <td><xsl:value-of select="opisOsoby/nazwisko"/></td>
                                <td><xsl:value-of select="opisOsoby/imie"/></td>
                                <td><xsl:value-of select="opisOsoby/dataUrodzenia"/></td>
                                <td><xsl:value-of select="pokrewienstwoOsobyZCzlonkiemRodziny/ns4:wartosc"/></td>
                                <td><xsl:value-of select="rolaRodzajOsobyWRodzinie/ns4:wartosc"/></td>
                            </tr>
                        </xsl:for-each>
                    </table>
                </xsl:for-each>

                <xsl:for-each select="wniosek">
                    <table>
                        <caption>Dane wniosku</caption>
                        <tr>
                            <td class="label">Data wpłynięcia wniosku</td>
                            <td><xsl:value-of select="date:formatDate(dane/dataWplynieciaWniosku, 'yyyy-MM-dd')"/></td>
                            <td class="label">Data zamknięcia sprawy</td>
                            <td><xsl:value-of select="date:formatDate(dane/dataZamknieciaSprawy, 'yyyy-MM-dd')"/></td>
                        </tr>
                        <tr>
                            <td class="label">Rodzaj wnioskodawcy</td>
                            <td><xsl:value-of select="dane/rodzajWnioskodawcy/ns4:wartosc"/></td>
                            <td class="label">Rodzaj wniosku</td>
                            <td><xsl:value-of select="dane/rodzajWniosku/ns4:wartosc"/></td>
                        </tr>
                        <tr>
                            <td class="label">Status wniosku</td>
                            <td><xsl:value-of select="dane/statusWniosku/ns4:wartosc"/></td>
                            <td class="label"></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="label">Numer wniosku</td>
                            <td><xsl:value-of select="wyroznik/nrUrzedowy"/></td>
                            <td class="label">Jednostka</td>
                            <td>
                                <xsl:variable name="_KodLokalizacjiLubNTS" select="wyroznik/wyroznikSD/ns2:jednostkaTerenowaKod" />

                                <xsl:value-of select="$_KodLokalizacjiLubNTS"/>
                                <br/>
                                <xsl:value-of select="$KodLokalizacji[@key = $_KodLokalizacjiLubNTS]" />
                                <br/>
                                <xsl:value-of select="$KodNTS[@key = $_KodLokalizacjiLubNTS]" />
                                <br/>
                                <xsl:value-of select="$KodNUTS[@key = $_KodLokalizacjiLubNTS]" />
                            </td>
                        </tr>
                    </table>
                </xsl:for-each>

                <xsl:for-each select="decyzja">
                    <table>
                        <caption>Dane decyzji</caption>
                        <tr>
                            <td class="label">Nr decyzji</td>
                            <td><xsl:value-of select="wyroznik/nrUrzedowy"/></td>
                            <td class="label">Wniosek</td>
                            <td><xsl:value-of select="wniosek/nrUrzedowy"/></td>
                        </tr>
                        <tr>
                            <td class="label">Data podjęcia decyzji</td>
                            <td><xsl:value-of select="date:format-date(dane/dataPodjeciaDecyzji, 'yyyy-MM-dd')"/></td>
                            <td class="label">Data uprawomocnienia</td>
                            <td><xsl:value-of select="date:format-date(dane/dataUprawomocnienia, 'yyyy-MM-dd')"/></td>
                        </tr>
                        <tr>
                            <td class="label">Instancja decyzji</td>
                            <td><xsl:value-of select="dane/instancjaDecyzji/ns4:wartosc"/></td>
                            <td class="label">Rodzaj decyzji</td>
                            <td><xsl:value-of select="dane/rodzajDecyzji/ns4:wartosc"/></td>
                        </tr>
                        <tr>
                            <td class="label">Jednostka</td>
                            <td>
                                <xsl:variable name="_KodLokalizacjiLubNTS" select="wyroznik/wyroznikSD/ns2:jednostkaTerenowaKod" />

                                <xsl:value-of select="$_KodLokalizacjiLubNTS"/>
                                <br/>
                                <xsl:value-of select="$KodLokalizacji[@key = $_KodLokalizacjiLubNTS]" />
                                <br/>
                                <xsl:value-of select="$KodNTS[@key = $_KodLokalizacjiLubNTS]" />
                                <br/>
                                <xsl:value-of select="$KodNUTS[@key = $_KodLokalizacjiLubNTS]" />
                            </td>
                            <td class="label"></td>
                            <td></td>
                        </tr>
                        <xsl:choose>
                            <xsl:when test="powodOdmowy">
                                <tr>
                                    <td class="label">Powód odmowy</td>
                                    <td colspan='3'>
                                        <ol>
                                            <xsl:for-each select="powodOdmowy">
                                                <li><xsl:value-of select="powodOdmowy/ns4:wartosc"/></li>
                                            </xsl:for-each>
                                        </ol>
                                    </td>
                                </tr>
                            </xsl:when>
                        </xsl:choose>
                        <xsl:choose>
                            <xsl:when test="dane/odwolanieOdDecyzji">
                                <tr>
                                    <td class="label" colspan="4">Osoba złożyła odwołanie od decyzji</td>
                                </tr>
                                <tr>
                                    <td class="label">Nr urzędowy</td>
                                    <td><xsl:value-of select="dane/odwolanieOdDecyzji/nrUrzedowy"/></td>
                                    <td class="label">Data złożenia odwołania</td>
                                    <td><xsl:value-of select="date:format-date(dane/odwolanieOdDecyzji/dataZlozenia, 'yyyy-MM-dd')"/></td>
                                </tr>
                                <tr>
                                    <td class="label">Status odwołania</td>
                                    <td colspan='3'><xsl:value-of select="dane/odwolanieOdDecyzji/status/ns4:wartosc"/></td>
                                </tr>
                            </xsl:when>
                        </xsl:choose>
                    </table>
                </xsl:for-each>

                <xsl:for-each select="swiadczenie">
                    <table>
                        <caption>Dane świadczenia</caption>
                        <tr>
                            <td class="label">Okres świadczeniowy</td>
                            <td><xsl:value-of select="dane/okresSwiadczeniowy/ns4:wartosc"/></td>
                            <td class="label">Rodzaj świadczenia</td>
                            <td><xsl:value-of select="dane/rodzajSwiadczenia/ns4:wartosc"/></td>
                        </tr>
                        <tr>
                            <td class="label">Status świadczenia</td>
                            <td><xsl:value-of select="dane/statusSwiadczenia/ns4:wartosc"/></td>
                            <td class="label">Wartość świadczenia</td>
                            <td><xsl:value-of select="format-number(dane/wartoscSwiadczenia/wartosc, '0,00')"/></td>
                        </tr>
                        <tr>
                            <td class="label">Data początku</td>
                            <td><xsl:value-of select="date:format-date(dane/dataPoczatku, 'yyyy-MM-dd')"/></td>
                            <td class="label">Data zakończenia</td>
                            <td><xsl:value-of select="date:format-date(dane/dataZakonczenia, 'yyyy-MM-dd')"/></td>
                        </tr>
                        <tr>
                            <td class="label">Jednostka</td>
                            <td>
                                <xsl:variable name="_KodLokalizacjiLubNTS" select="wyroznik/wyroznikSD/ns2:jednostkaTerenowaKod" />

                                <xsl:value-of select="$_KodLokalizacjiLubNTS"/>
                                <br/>
                                <xsl:value-of select="$KodLokalizacji[@key = $_KodLokalizacjiLubNTS]" />
                                <br/>
                                <xsl:value-of select="$KodNTS[@key = $_KodLokalizacjiLubNTS]" />
                                <br/>
                                <xsl:value-of select="$KodNUTS[@key = $_KodLokalizacjiLubNTS]" />
                            </td>
                            <td class="label">Decyzja</td>
                            <td><xsl:value-of select="decyzja/nrUrzedowy"/></td>
                        </tr>
                        <xsl:choose>
                            <xsl:when test="dane/swiadczeniobiorca/osoba">
                                <tr>
                                    <td class="label">Swiadczeniobiorca</td>
                                    <td colspan="3">
                                        <xsl:for-each select="dane/swiadczeniobiorca/osoba">
                                            <xsl:variable name="czlonekRodziny" select="key('czlonekRodziny', idOsobySD)"/>
                                            <div>
                                                <xsl:value-of select="$czlonekRodziny/opisOsoby/nazwisko"/>
                                                <xsl:text> </xsl:text>
                                                <xsl:value-of select="$czlonekRodziny/opisOsoby/imie"/>
                                            </div>
                                        </xsl:for-each>
                                    </td>
                                </tr>
                            </xsl:when>
                        </xsl:choose>
                    </table>
                </xsl:for-each>

            </xsl:for-each>
        </div>
    </xsl:template>
</xsl:stylesheet>