<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="KodpUdostepnijInformacjeDodatkowe">

        <div class="odpowiedz">
            <table>
                <caption>Udostępnienie informacji dodatkowych z usługi ePodatki - dane odpowiedzi</caption>
                <tr>
                    <td class="label">Status odpowiedzi dotyczący podatku należnego duchownych</td>
                    <xsl:choose>
                        <xsl:when test="//statusKwotaPodatkuNaleznegoDuchownych = '0D'"><td>udostępniono dane</td></xsl:when>
                        <xsl:when test="//statusKwotaPodatkuNaleznegoDuchownych = '3D'"><td>brak danych w zakresie zapytania</td></xsl:when>
                        <xsl:when test="//statusKwotaPodatkuNaleznegoDuchownych = '4D'"><td>znaleziono niezatwierdzony dokument, dane nie mogą zostać zwrócone</td></xsl:when>
                        <xsl:when test="//statusKwotaPodatkuNaleznegoDuchownych = '6D'"><td>podany w zapytaniu rok nie jest obsługiwany przez usługę</td></xsl:when>
                    </xsl:choose>
                </tr>
                <tr>
                    <td class="label">Status odpowiedzi dotyczący podatku z decyzji KP</td>
                    <xsl:choose>
                        <xsl:when test="//statusKwotaPodatkuZDecyzjiKP = '0C'"><td>udostępniono dane</td></xsl:when>
                        <xsl:when test="//statusKwotaPodatkuZDecyzjiKP = '3C'"><td>brak danych w zakresie zapytania</td></xsl:when>
                        <xsl:when test="//statusKwotaPodatkuZDecyzjiKP = '6C'"><td>podany w zapytaniu rok nie jest obsługiwany przez usługę</td></xsl:when>
                    </xsl:choose>
                </tr>
                <tr>
                    <td class="label">Status odpowiedzi dotyczący ryczałtu od przychodów ewidencjonowanych</td>
                    <xsl:choose>
                        <xsl:when test="//statusWysokoscPrzychoduRE = '0B'"><td>udostępniono dane</td></xsl:when>
                        <xsl:when test="//statusWysokoscPrzychoduRE = '2B'"><td>niezgodność sposobu rozliczenia (za podany okres istnieje wspólne zeznanie PIT-36/37)</td></xsl:when>
                        <xsl:when test="//statusWysokoscPrzychoduRE = '3B'"><td>brak danych w zakresie zapytania</td></xsl:when>
                        <xsl:when test="//statusWysokoscPrzychoduRE = '4B'"><td>znaleziono niezatwierdzony dokument, dane nie mogą zostać zwrócone</td></xsl:when>
                        <xsl:when test="//statusWysokoscPrzychoduRE = '5B'"><td>została wydana decyzja wymiarowa do deklaracji, dane nie mogą zostać zwrócone</td></xsl:when>
                        <xsl:when test="//statusWysokoscPrzychoduRE = '6B'"><td>podany w zapytaniu rok nie jest obsługiwany przez usługę</td></xsl:when>
                        <xsl:when test="//statusWysokoscPrzychoduRE = '7B'"><td>wskazany/i w pytaniu podatnik/cy złożył/li więcej deklaracji tego samego typu w jednym okresie</td></xsl:when>
                    </xsl:choose>
                </tr>
            </table>

            <table>
                <tr>
                    <td class="label">Kwota podatku należnego</td>
                    <td><xsl:value-of select="format-number(//KwotaPodatkuNaleznego, '0,00')"/></td>
                    <td class="label">Kwota podatku z decyzji</td>
                    <td><xsl:value-of select="format-number(//KwotaPodatkuZDecyzji, '0,00')"/></td>
                </tr>
            </table>

            <xsl:if test="//ListaPrzychodow">
                <table style="width: 95%; margin: auto; table-layout: fixed;">
                    <caption>Przychody podatnika dot. ryczałtu od przychodów ewidencjonowanych.</caption>
                    <thead>
                        <th style="width: 2%">Lp.</th>
                        <th style="width: 20%">Stawka ryczałtu od przychodów ewidencjonowanych w procentach</th>
                        <th style="width: 20%">Wysokość przychodu wykazana przez podatnika</th>
                        <th style="width: 20%">Wysokość przychodu określona przez organ </th>
                    </thead>
                    <xsl:for-each select="//ListaPrzychodow/Przychod">
                        <xsl:variable name="lp" select="position()"/>
                        <tr>
                            <td><xsl:value-of select="$lp" /></td>
                            <td><xsl:value-of select="format-number(Stawka, '0,00')"/>%</td>
                            <td><xsl:value-of select="format-number(WysokoscWykazana, '0,00')"/></td>
                            <td><xsl:value-of select="format-number(WysokoscOkreslona, '0,00')"/></td>
                        </tr>
                    </xsl:for-each>
                </table>
            </xsl:if>
        </div>

    </xsl:template>
</xsl:stylesheet>

