<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="zadaniePrzychodyZwolnioneKwotaZwrotu">

        <div class="odpowiedz">
            <table>
                <caption>Udostępnienie danych z ePodatki - dane żądania</caption>
                <tr>
                    <td class="label">Numer sprawy</td>
                    <td colspan="3">
                        <xsl:value-of select="//kontekst/nrSprawy"/>
                    </td>
                </tr>

                <xsl:if test="//kryteriaWyszukania">
                    <tr>
                        <td class="label">Dane podatnika - Pesel</td>
                        <td colspan="3">
                            <xsl:value-of select="//kryteriaWyszukania/osobaPodstawowa/pesel"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Nazwisko</td>
                        <td>
                            <xsl:value-of select="//kryteriaWyszukania/osobaPodstawowa/nazwisko"/>
                        </td>
                        <td class="label">Imię</td>
                        <td>
                            <xsl:value-of select="//kryteriaWyszukania/osobaPodstawowa/imie"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Rok podatkowy</td>
                        <td colspan="3">
                            <xsl:value-of select="//kryteriaWyszukania/rokPodatkowy"/>
                        </td>
                    </tr>
                    <xsl:if test="count(//kryteriaWyszukania/osobaDodatkowa) > 0">
                        <tr>
                            <td class="label">Dane współmałżonka/dziecka - Pesel</td>
                            <td colspan="3">
                                <xsl:value-of select="//kryteriaWyszukania/osobaDodatkowa/pesel"/>
                            </td>
                        </tr>
                        <tr>
                            <td class="label">Nazwisko</td>
                            <td>
                                <xsl:value-of select="//kryteriaWyszukania/osobaDodatkowa/nazwisko"/>
                            </td>
                            <td class="label">Imię</td>
                            <td>
                                <xsl:value-of select="//kryteriaWyszukania/osobaDodatkowa/imie"/>
                            </td>
                        </tr>
                    </xsl:if>
                </xsl:if>
            </table>
        </div>

    </xsl:template>
</xsl:stylesheet>