<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="KzadUdostepnianieDanychOsoby">
        <div class="odpowiedz">
            <table>
                <caption>Usługa Straży Granicznej - dane żądania</caption>
                <tr>
                    <td class="label">Numer sprawy</td>
                    <td colspan="3">
                        <xsl:value-of select="//kontekst/nrSprawy"/>
                    </td>
                </tr>
                <xsl:if test="//kryteriaWyszukania/pesel">
                    <tr>
                        <td class="label">PESEL</td>
                        <td>
                            <xsl:value-of select="//kryteriaWyszukania/pesel"/>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="//kryteriaWyszukania/kryteriaImieNazwisko">
                    <tr>
                        <td class="label">Nazwisko</td>
                        <td>
                            <xsl:value-of select="//kryteriaWyszukania/kryteriaImieNazwisko/nazwisko"/>
                        </td>
                        <td class="label">Imię</td>
                        <td>
                            <xsl:value-of select="//kryteriaWyszukania/kryteriaImieNazwisko/imie"/>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="//kryteriaWyszukania/kryteriaNazwiskoDataUrodzenia">
                    <tr>
                        <td class="label">Nazwisko</td>
                        <td>
                            <xsl:value-of select="//kryteriaWyszukania/kryteriaNazwiskoDataUrodzenia/nazwisko"/>
                        </td>
                        <td class="label">Data urodzenia</td>
                        <td>
                            <xsl:value-of select="//kryteriaWyszukania/kryteriaNazwiskoDataUrodzenia/dataUrodzenia"/>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="//kryteriaWyszukania/seriaNrDokumentu">
                    <tr>
                        <td class="label">Seria i nr dokumentu</td>
                        <td>
                            <xsl:value-of select="//kryteriaWyszukania/seriaNrDokumentu"/>
                        </td>
                    </tr>
                </xsl:if>

            </table>
        </div>
    </xsl:template>
</xsl:stylesheet>