<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns2="http://mpips.gov.pl/xsd/csizs/pi/sg/v1"
                xmlns:ns3="http://mpips.gov.pl/xsd/csizs/typy/v4"
                xmlns:date="http://exslt.org/dates-and-times">
    <xsl:template match="/">
        <html>
            <head>
                <meta charset="utf-8" />
                <style>
                    <xsl:value-of select="document('../../../../../../../../css/style.html')/html/head/style"/>
                    .label {
                        text-align: right;
                    }
                </style>
            </head>
            <body>
                <div class="odpowiedz">
                    <table>
                        <caption>Raport</caption>
                        <tr>
                            <td class="label">Liczba osób na raporcie</td>
                            <td><xsl:value-of select="count(//osoba)"/></td>
                        </tr>
                    </table>
                    <xsl:for-each select="//ns2:raport/osoba">
                        <table>
                            <tr>
                                <td class="label">Nazwisko</td>
                                <td><xsl:value-of select="ns3:nazwisko"/></td>
                                <td class="label">Imię</td>
                                <td><xsl:value-of select="ns3:imie"/></td>
                            </tr>
                            <tr>
                                <td class="label">Pesel</td>
                                <td><xsl:value-of select="ns3:pesel"/></td>
                                <td class="label">Data urodzenia</td>
                                <td><xsl:value-of select="ns3:dataUrodzenia"/></td>
                            </tr>
                            <tr>
                                <td class="label">Data końca uprawnień</td>
                                <td colspan="3"><xsl:value-of select="dataKoncaUprawnien"/></td>
                            </tr>
                            <xsl:if test="przekroczenia">
                                <tr>
                                    <td colspan="4">
                                        <table style="width: 70%; margin: auto;">
                                            <caption>Przekroczenia granicy</caption>
                                            <tr>
                                                <th>Data przekroczenia</th>
                                                <th>Kierunek przekroczenia</th>
                                                <th>Czy wjazd do RP w ramach ewakuacji</th>
                                            </tr>
                                            <xsl:for-each select="przekroczenia/przekroczenie">
                                                <tr>
                                                    <td><xsl:value-of select="data"/></td>
                                                    <td>
                                                        <xsl:choose>
                                                            <xsl:when test="kierunek = 'P'">PRZYJAZD</xsl:when>
                                                            <xsl:otherwise>WYJAZD</xsl:otherwise>
                                                        </xsl:choose>
                                                    </td>
                                                    <td>
                                                    <xsl:choose>
                                                        <xsl:when test="@czyEwakuacja = 'true'">TAK</xsl:when>
                                                        <xsl:otherwise>NIE</xsl:otherwise>
                                                    </xsl:choose>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </table>
                                    </td>
                                </tr>
                            </xsl:if>

                        </table>
                    </xsl:for-each>
                </div>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>