<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:decimal-format grouping-separator="." decimal-separator="," NaN=""/>

    <xsl:include href="kzadZlecenieUdostepnieniaSkladek.xslt"/>
    <xsl:include href="kzadZlecenieUdostepnieniaDanychUbezp.xslt"/>

    <xsl:include href="kodpPobranieWynikuZleceniaSkladki.xslt"/>
    <xsl:include href="kodpPobranieWynikuZleceniaDaneUbezp.xslt"/>

    <xsl:template match="/">
        <html>
            <head>
                <meta charset="utf-8" />
                <style>
                    <xsl:value-of select="document('../../../../../../../../css/style.html')/html/head/style"/>
                </style>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="local-name(/*) = 'kzadZlecenieUdostepnieniaSkladek'">
                        <xsl:call-template name="kzadZlecenieUdostepnieniaSkladek"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'kzadZlecenieUdostepnieniaDanychUbezp'">
                        <xsl:call-template name="kzadZlecenieUdostepnieniaDanychUbezp"/>
                    </xsl:when>

                    <xsl:when test="local-name(/*) = 'kodpPobranieWynikuZleceniaSkladki'">
                        <xsl:call-template name="kodpPobranieWynikuZleceniaSkladki"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'kodpPobranieWynikuZleceniaDaneUbezp'">
                        <xsl:call-template name="kodpPobranieWynikuZleceniaDaneUbezp"/>
                    </xsl:when>

                    <xsl:otherwise>
                        <xsl:text>Nieznany root element !</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>