<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:date="http://exslt.org/dates-and-times">

    <xsl:template match="/" name="KodpUdostepnianieDanychCeidg">
        <xsl:variable name="StatusOdpowiedzi" select="document('../../../../../../../../xml/StatusOdpowiedziCEIDG.xml')/properties/entry" />
        <xsl:variable name="TakNie" select="document('../../../../../../../../xml/TakNie.xml')/properties/entry" />

        <div class="odpowiedz">
            <table>
                <caption>Odpowiedź</caption>
                <tr>
                    <td class="label">Status odpowiedzi</td>
                    <td>
                        <xsl:variable name="_Status" select="//statusOdpowiedzi" />
                        <xsl:value-of select="$StatusOdpowiedzi[@key = $_Status]" />
                    </td>
                </tr>
            </table>
            <xsl:for-each select="//Odpowiedz">

                <xsl:if test="danePodstawowe">

                    <xsl:variable name="WpisDanePodstawowe" select="danePodstawowe/wpisy/wpis" />
                    <xsl:variable name="WnioskodawcaPodstawowe" select="$WpisDanePodstawowe/wnioskodawca/daneWnioskodawcy" />
                    <xsl:variable name="EwidencjaGospPodstawowe" select="$WpisDanePodstawowe/ewidencjaGospodarcza" />
                    <xsl:variable name="ZawieszeniePodstawowe" select="$WpisDanePodstawowe/zawieszenieDzialalnosci" />
                    <xsl:variable name="WznowieniePodstawowe" select="$WpisDanePodstawowe/wznowienieDzialalnosci" />
                    <xsl:variable name="ZaprzestaniePodstawowe" select="$WpisDanePodstawowe/zaprzestanieDzialalnosci" />

                    <table>
                        <tr>
                            <td class="label">Identyfikator:</td>
                            <td><xsl:value-of select="$WpisDanePodstawowe/identyfikator"/></td>
                        </tr>
                    </table>

                    <!--wnioskodawca dane podstawowe-->
                    <table>
                        <tr>
                            <td class="label">Imię</td>
                            <td><xsl:value-of select="$WnioskodawcaPodstawowe/imie"/></td>
                            <td class="label">Nazwisko</td>
                            <td><xsl:value-of select="$WnioskodawcaPodstawowe/nazwisko"/></td>
                        </tr>
                        <tr>
                            <td class="label">PESEL</td>
                            <td><xsl:value-of select="$WnioskodawcaPodstawowe/identyfikatory/PESEL"/></td>
                            <td class="label">NIP</td>
                            <td><xsl:value-of select="$WnioskodawcaPodstawowe/identyfikatory/numerNip"/></td>
                        </tr>
                        <tr>
                            <td class="label">Regon</td>
                            <td colspan="3"><xsl:value-of select="$WnioskodawcaPodstawowe/identyfikatory/numerRegon"/></td>
                        </tr>
                    </table>

                    <!--ewidencja gospodarcza-->
                    <xsl:if test="$EwidencjaGospPodstawowe">
                        <table>
                            <tr>
                                <td class="label">Firma przedsiębiorcy</td>
                                <td><xsl:value-of select="$EwidencjaGospPodstawowe/firmaPrzedsiebiorcy"/></td>
                                <td class="label">Status</td>
                                <td><xsl:value-of select="$EwidencjaGospPodstawowe/status"/></td>
                            </tr>
                            <tr>
                                <td class="label">Data rozpoczęcia działalności</td>
                                <td><xsl:value-of select="date:formatDate($EwidencjaGospPodstawowe/dataRozpoczeciaDzialalnosci/czas, 'yyyy-MM-dd')"/></td>
                                <td class="label">Miejsce wykonywania - Powiat</td>
                                <td><xsl:value-of select="$EwidencjaGospPodstawowe/miejscaWykonywaniaDzialalnosci/glowneMiejsceDzialalnosci/powiat"/></td>
                            </tr>
                            <tr>
                                <td class="label">Miejsce wykonywania - Gmina</td>
                                <td><xsl:value-of select="$EwidencjaGospPodstawowe/miejscaWykonywaniaDzialalnosci/glowneMiejsceDzialalnosci/gmina"/></td>
                                <td class="label">Przeważający rodzaj działalności</td>
                                <td><xsl:value-of select="$EwidencjaGospPodstawowe/rodzajeDzialalnosci/przewazajacy"/></td>
                            </tr>
                            <tr>
                                <td colspan="2" class="label">PKD</td>
                                <td colspan="2">
                                    <xsl:for-each select="$EwidencjaGospPodstawowe/rodzajeDzialalnosci/PKD2007">
                                        <xsl:value-of select="."/>
                                        <xsl:if test='position() != last()'>, </xsl:if>
                                    </xsl:for-each>
                                </td>
                            </tr>
                        </table>
                    </xsl:if>

                    <xsl:if test="$ZawieszeniePodstawowe/okres">
                        <table>
                            <caption>Zawieszenie działalności</caption>
                            <tr>
                                <th>Zawieszenie od</th>
                                <th>Zawieszenie do</th>
                            </tr>
                            <tr>
                                <td><xsl:value-of select="$ZawieszeniePodstawowe/okres/od"/></td>
                                <td><xsl:value-of select="$ZawieszeniePodstawowe/okres/_do"/></td>
                            </tr>
                        </table>
                    </xsl:if>

                    <xsl:if test="$WznowieniePodstawowe/od/czas">
                        <table>
                            <tr>
                                <td class="label">Wznowienie działalności od</td>
                                <td><xsl:value-of select="date:formatDate($WznowieniePodstawowe/od/czas, 'yyyy-MM-dd')"/></td>
                            </tr>
                        </table>
                    </xsl:if>

                    <xsl:if test="$ZaprzestaniePodstawowe/od/czas">
                        <table>
                            <tr>
                                <td class="label">Zaprzestanie działalności od</td>
                                <td><xsl:value-of select="date:formatDate($ZaprzestaniePodstawowe/od/czas, 'yyyy-MM-dd')"/></td>
                            </tr>
                        </table>
                    </xsl:if>

                </xsl:if>

                <xsl:if test="danePelne">

                    <xsl:variable name="WpisPelne" select="danePelne/wpis"/>
                    <xsl:variable name="WnioskodawcaPelne" select="$WpisPelne/wnioskodawca"/>
                    <xsl:variable name="EwidencjaPelne" select="$WpisPelne/ewidencjaGospodarcza"/>

                    <table>
                        <tr>
                            <td class="label">Identyfikator</td>
                            <td><xsl:value-of select="$WpisPelne/identyfikator"/></td>
                            <td class="label">Imię</td>
                            <td><xsl:value-of select="$WnioskodawcaPelne/daneWnioskodawcy/imie"/></td>
                        </tr>
                        <tr>
                            <td class="label">Nazwisko</td>
                            <td><xsl:value-of select="$WnioskodawcaPelne/daneWnioskodawcy/nazwisko"/></td>
                            <td class="label">PESEL</td>
                            <td><xsl:value-of select="$WnioskodawcaPelne/daneWnioskodawcy/identyfikatory/PESEL"/></td>
                        </tr>
                        <tr>
                            <td class="label">NIP</td>
                            <td><xsl:value-of select="$WnioskodawcaPelne/daneWnioskodawcy/identyfikatory/numerNip"/></td>
                            <td class="label">Regon</td>
                            <td><xsl:value-of select="$WnioskodawcaPelne/daneWnioskodawcy/identyfikatory/numerRegon"/></td>
                        </tr>
                        <tr>
                            <td class="label">Oświadczenia - brak zakazu prowadzenia działalności</td>
                            <td>
                                <xsl:variable name="_BrakZakazuProwadzeniaDG" select="$WnioskodawcaPelne/oswiadczenia/brakZakazuProwadzeniaDG" />
                                <xsl:value-of select="$TakNie[@key = $_BrakZakazuProwadzeniaDG]" />
                            </td>
                        </tr>
                        <tr>
                            <td class="label">Firma</td>
                            <td><xsl:value-of select="$EwidencjaPelne/firmaPrzedsiebiorcy"/></td>
                            <td class="label">Status</td>
                            <td><xsl:value-of select="$EwidencjaPelne/status"/></td>
                        </tr>
                        <tr>
                            <td class="label">Data rozpoczęcia działalności</td>
                            <td><xsl:value-of select="date:formatDate($EwidencjaPelne/dataRozpoczeciaDzialalnosci/czas, 'yyyy-MM-dd')"/></td>
                            <td class="label">Główne miejsce wykonywania działalności</td>
                            <td>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/glowneMiejsceDzialalnosci/powiat"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/glowneMiejsceDzialalnosci/gmina"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/glowneMiejsceDzialalnosci/miejscowosc"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/glowneMiejsceDzialalnosci/ulica"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/glowneMiejsceDzialalnosci/nrBudynku"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/glowneMiejsceDzialalnosci/nrLokalu"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/glowneMiejsceDzialalnosci/wojewodztwo"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/glowneMiejsceDzialalnosci/kodPocztowy"/><br/>
                            </td>
                        </tr>
                        <tr>
                            <td class="label">Dodatkowe miejsce wykonywania działalności</td>
                            <td>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/dodatkoweMiejsceDzialalnosci/powiat"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/dodatkoweMiejsceDzialalnosci/gmina"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/dodatkoweMiejsceDzialalnosci/miejscowosc"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/dodatkoweMiejsceDzialalnosci/ulica"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/dodatkoweMiejsceDzialalnosci/nrBudynku"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/dodatkoweMiejsceDzialalnosci/nrLokalu"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/dodatkoweMiejsceDzialalnosci/wojewodztwo"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/miejscaWykonywaniaDzialalnosci/dodatkoweMiejsceDzialalnosci/kodPocztowy"/><br/>
                            </td>
                            <td class="label">Adres do doręczeń</td>
                            <td>
                                <xsl:value-of select="$EwidencjaPelne/adresDoDoreczen/powiat"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/adresDoDoreczen/gmina"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/adresDoDoreczen/miejscowosc"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/adresDoDoreczen/ulica"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/adresDoDoreczen/nrBudynku"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/adresDoDoreczen/nrLokalu"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/adresDoDoreczen/wojewodztwo"/><br/>
                                <xsl:value-of select="$EwidencjaPelne/adresDoDoreczen/kodPocztowy"/><br/>
                            </td>
                        </tr>
                        <tr>
                            <td class="label">Przeważający rodzaj działalności</td>
                            <td><xsl:value-of select="$EwidencjaPelne/rodzajeDzialalnosci/przewazajacy"/></td>
                            <td class="label">PKD</td>
                            <td>
                                <xsl:for-each select="$EwidencjaPelne/rodzajeDzialalnosci/PKD2007">
                                    <xsl:value-of select="."/>
                                    <xsl:if test='position() != last()'>, </xsl:if>
                                </xsl:for-each>
                            </td>
                        </tr>
                        <xsl:variable name="ZawieszenieOkres" select="$WpisPelne/zawieszenieDzialalnosci/okres"/>
                        <tr>
                            <td class="label">Zawieszenie działalności od</td>
                            <td><xsl:value-of select="date:formatDate($ZawieszenieOkres/od, 'yyyy-MM-dd')"/></td>
                            <td class="label">Zawieszenie działalności do</td>
                            <td><xsl:value-of select="date:formatDate($ZawieszenieOkres/_do, 'yyyy-MM-dd')"/></td>
                        </tr>
                        <tr>
                            <td class="label">Wznowienie działalności od</td>
                            <td><xsl:value-of select="date:formatDate($WpisPelne/wznowienieDzialalnosci/od/czas, 'yyyy-MM-dd')"/></td>
                            <td class="label">Zaprzestanie działalności od</td>
                            <td><xsl:value-of select="date:formatDate($WpisPelne/zaprzestanieDzialalnosci/od/czas, 'yyyy-MM-dd')"/></td>
                        </tr>
                    </table>

                </xsl:if>
            </xsl:for-each>
        </div>

    </xsl:template>
</xsl:stylesheet>
