<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="kodpPobierzSkladkiZdrowotne">
        <div class="odpowiedz">
            <table>
                <caption>Odpowiedź</caption>
                <tr>
                    <td class="label">Status odpowiedzi</td>
                    <td colspan="2">
                        <xsl:choose>
                            <xsl:when test="//statusOdpowiedzi = 'NIEPOPRAWNE_DANE_OPERACJI'">Niepoprawne dane w kryteriach wyszukiwania</xsl:when>
                            <xsl:when test="//statusOdpowiedzi = 'OSOBA_ZNALEZIONA_SA_DANE'">Osoba została znaleziona, pobrano dane</xsl:when>
                            <xsl:when test="//statusOdpowiedzi = 'OSOBA_NIE_ZOSTALA_ZNALEZIONA'">Osoba nie została znaleziona lub znaleziona osoba nie spełnia innych warunków np.: nie jest płatnikiem we wskazanym okresie</xsl:when>
                            <xsl:when test="//statusOdpowiedzi = 'ZNALEZIONO_WIELE_OSOB'">Wg podanych kryteriów znaleziono wiele osób, konieczne doprecyzowanie kryteriów lub kontakt z pracownikiem KRUS</xsl:when>
                            <xsl:when test="//statusOdpowiedzi = 'OSOBA_JEST_PLATNIKIEM_Z_INNA_PODSTAWA'">Osoba jest płatnikiem z inną podstawą prawną. Status dotyczy tylko osób, które są rolnikami i podlegają ubezpieczeniu zdrowotnemu z tego tytułu (niezależnie od tego czy sami opłacają składki czy budżet państwa je płaci), i jednocześnie nie są emerytami/rencistami rolniczymi i nie prowadzą działów specjalnych produkcji rolnej w zadanym okresie.</xsl:when>
                            <xsl:when test="//statusOdpowiedzi = 'ZLECENIE_W_TRAKCIE_REALIZACJI'">Dane nie zostały jeszcze przygotowane</xsl:when>
                        </xsl:choose>
                    </td>
                </tr>
            </table>
            <xsl:for-each select="//platnik">
                <table>
                    <caption><b>PŁATNIK</b></caption>
                    <tr>
                        <td class="label">Imię</td>
                        <td><xsl:value-of select="imie"/></td>
                        <td class="label">Nazwisko</td>
                        <td><xsl:value-of select="nazwisko"/></td>
                    </tr>
                    <tr>
                        <td class="label">PESEL</td>
                        <td><xsl:value-of select="pesel"/></td>
                        <td class="label">Data urodzenia</td>
                        <td><xsl:value-of select="dataUrodzenia"/></td>
                    </tr>
                </table>
                <table>
                    <caption><b>SKŁADKA ZDROWOTNA</b></caption>
                    <tr>
                        <th style="width: 5%;">Data ostatniej wpłaty</th>
                        <th>Kod tytułu ubezpieczenia</th>
                        <th style="width: 10%;">Kwota opłaconej składki</th>
                        <th style="width: 10%;">Kwota przypisanej składki</th>
                        <th style="width: 5%; text-wrap: none;">Okres od</th>
                        <th style="width: 5%; text-wrap: none;">Okres do</th>
                        <th style="width: 5%; text-wrap: none;">Stan danych na dzień</th>
                    </tr>
                    <xsl:for-each select="skladki">
                        <tr>
                            <td style="width: 5%;"><xsl:value-of select="dataOstatniejWplaty"/></td>
                            <td><xsl:value-of select="kodTytulu"/></td>
                            <td style="width: 10%;"><xsl:value-of select="format-number(kwotaOplaconejSkladki, '0.00')"/></td>
                            <td style="width: 10%;"><xsl:value-of select="format-number(kwotaPrzypisanejSkladki, '0.00')"/></td>
                            <td style="width: 5%; text-wrap: none;"><xsl:value-of select="okresSkladkiOd"/></td>
                            <td style="width: 5%; text-wrap: none;"><xsl:value-of select="okresSkladkiDo"/></td>
                            <td style="width: 5%; text-wrap: none;"><xsl:value-of select="stanDanychNaDzien"/></td>
                        </tr>
                    </xsl:for-each>
                    <tr>
                        <td class="label" style="text-align: right" colspan="2">SUMA:</td>
                        <td><xsl:value-of select="format-number(sum(skladki/kwotaOplaconejSkladki), '0.00')"/></td>
                        <td><xsl:value-of select="format-number(sum(skladki/kwotaPrzypisanejSkladki), '0.00')"/></td>
                        <td colspan="3"/>
                    </tr>
                </table>
            </xsl:for-each>
        </div>
    </xsl:template>
</xsl:stylesheet>

