<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="kzadPrzygotujSkladkiZdrowotne">
        <div class="odpowiedz">
            <table>
                <caption>Usługa KRUS - dane żądania</caption>
                <tr>
                    <td class="label">Numer sprawy</td>
                    <td colspan="3">
                        <xsl:value-of select="//kontekst/nrSprawy"/>
                    </td>
                </tr>
                <xsl:if test="count(//kryteria/pesel) > 0">
                    <tr>
                        <td class="label">Pesel</td>
                        <td colspan="3">
                            <xsl:value-of select="//pesel"/>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="count(//kryteria/nazwisko) > 0">
                    <tr>
                        <td class="label">Nazwisko</td>
                        <td>
                            <xsl:value-of select="//kryteria/nazwisko"/>
                        </td>
                        <td class="label">Imię</td>
                        <td>
                            <xsl:value-of select="//kryteria/imie"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Data urodzenia</td>
                        <td colspan="3">
                            <xsl:value-of select="//kryteria/dataUrodzenia"/>
                        </td>
                    </tr>
                </xsl:if>
                <tr>
                    <td class="label">Okres od</td>
                    <td>
                        <xsl:value-of select="//okresOd"/>
                    </td>
                    <td class="label">Okres do</td>
                    <td>
                        <xsl:value-of select="//okresDo"/>
                    </td>
                </tr>
            </table>
        </div>
    </xsl:template>
</xsl:stylesheet>