<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:decimal-format grouping-separator="." decimal-separator="," NaN=""/>

    <xsl:include href="zadanie.xslt"/>
    <xsl:include href="KodpUdostepnienieDanychODochodach.xslt"/>
    <xsl:include href="KodpUdostepnijInformacjeDodatkowe.xslt"/>

    <xsl:template match="/">
        <html>
            <head>
                <meta charset="utf-8" />
                <style>
                    <xsl:value-of select="document('../../../../../../../../css/style.html')/html/head/style"/>
                </style>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="local-name(/*) = 'KzadUdostepnianieDanychODochodach'">
                        <xsl:call-template name="zadanie"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KzadUdostepnijInformacjeDodatkowe'">
                        <xsl:call-template name="zadanie"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KodpUdostepnienieDanychODochodach'">
                        <xsl:call-template name="KodpUdostepnienieDanychODochodach"/>
                    </xsl:when>
                    <xsl:when test="local-name(/*) = 'KodpUdostepnijInformacjeDodatkowe'">
                        <xsl:call-template name="KodpUdostepnijInformacjeDodatkowe"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>Nieznany root element !</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>