<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="KodpUdostepnienieDanychODochodach">

        <div class="odpowiedz">
            <table>
                <caption>Udostępnienie danych z ePodatki - dane odpowiedzi</caption>
                <tr>
                    <td class="label">Status odpowiedzi</td>
                    <xsl:choose>
                        <xsl:when test="//statusOdpowiedzi = 0"><td>zidentyfikowano osoby i udostępniono dane</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 1"><td>nie znaleziono osób</td><td>Zweryfikuj w  rejestrze  PESEL i sprawdź, czy dane (nr PESEL, Imię pierwsze, Nazwisko) są zgodne - jeśli są zgodne, to należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 2"><td>niezgodność wspólnego rozliczenia (wspólnie/indywidualnie)</td><td>Komunikat wystąpi, jeśli zapytanie jest na podatnika a zeznanie złożono  wspólnie z małżonkiem bądź, jeśli zapytanie jest jednocześnie na podatnika i małżonka a podatnicy rozliczyli się osobno</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 3"><td>brak deklaracji podatkowych za podany okres</td><td>Podatnik nie złożył zeznania PIT</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 4"><td>znaleziono niezatwierdzoną deklarację, dane nie mogą być zwrócone</td><td>Należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 5"><td>została wydana decyzja wymiarowa, dane nie mogą być zwrócone</td><td>Nie można wydzielić kwoty dochodu - należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 6"><td>podany w zapytaniu rok nie jest obsługiwany przez usługę</td><td>Dane za rok poprzedni będą dostępne od sierpnia bieżącego roku</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 7"><td>wskazany w pytaniu podatnik złożył więcej deklaracji tego samego typu w jednym okresie</td><td>Należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 8"><td>limit dochodu został przekroczony, wyślij zapytanie specjalne by uzyskać informacje</td><td>Dane można uzyskać poprzez wykonanie zapytania specjalnego</td></xsl:when>
                        <xsl:when test="//statusOdpowiedzi = 9"><td>zidentyfikowano osobę i udostępniono dane </td><td>Dla PIT-36 oraz PIT-37 kwota podatku należnego została obliczona od sumy dochodów obojga podatników, natomiast pozostałe pozycje dotyczą jedynie podatnika, którego dotyczyło zapytanie</td></xsl:when>
                    </xsl:choose>
                </tr>
                <tr>
                    <td class="label">Status odpowiedzi dotyczący ulgi na dziecko</td>
                    <xsl:choose>
                        <xsl:when test="//statusOdpowiedziUlga = '0A'"><td colspan="2">udostępniono dane</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziUlga = '2A'"><td colspan="2">niezgodność sposobu rozliczenia (wspólne/indywidualne)</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziUlga = '3A'"><td colspan="2">brak deklaracji PIT-36 / PIT-37 za podany okres lub w odnalezionych dokumentach nie została wypełniona pozycja dotycząca przysługującej kwoty różnicy</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziUlga = '4A'"><td colspan="2">znaleziono niezatwierdzoną deklarację PIT-36/PIT-37, dane nie mogą być zwrócone</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziUlga = '5A'"><td colspan="2">została wydana decyzja wymiarowa do deklaracji PIT-36/PIT-37, dane nie mogą zostać zwrócone</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziUlga = '6A'"><td colspan="2">podany w zapytaniu rok nie jest obsługiwany przez usługę</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziUlga = '7A'"><td colspan="2">wskazany/i w pytaniu podatnik/cy złożył/li więcej deklaracji tego samego typu w jednym okresie</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziUlga = '9A'"><td colspan="2">zidentyfikowano osobę i udostępniono dane (przysługująca kwota różnicy tzw. kwota zwrotu z tytułu niewykorzystanej ulgi na dzieci dotyczy obojga rodziców)</td></xsl:when>
                    </xsl:choose>
                </tr>
                <tr>
                    <td class="label">Status odpowiedzi dotyczący młodych</td>
                    <xsl:choose>
                        <xsl:when test="//statusOdpowiedziPrzychodyMlodych = '0E'"><td colspan="2">udostępniono dane</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziPrzychodyMlodych = '2E'"><td colspan="2">niezgodność sposobu rozliczenia</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziPrzychodyMlodych = '3E'"><td colspan="2">brak dokumentów PIT-36/PIT-37/PIT-11 za podany okres lub brak danych do odpowiedzi na dokumencie</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziPrzychodyMlodych = '4E'"><td colspan="2">znalezniono niezatwierdzony dokument PIT-36/PIT-37/PIT-11, dane nie mogą być zwrócone</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziPrzychodyMlodych = '5E'"><td colspan="2">została wydana decyzja wymiarowa, dane nie mogą być zwrócone</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziPrzychodyMlodych = '6E'"><td colspan="2">podany w zapytaniu rok nie jest obsługiwany przez usługę</td></xsl:when>
                        <xsl:when test="//statusOdpowiedziPrzychodyMlodych = '7E'"><td colspan="2">wskazany w pytaniu podatnik złożył więcej deklaracji tego samego typu w jednym okresie</td></xsl:when>
                    </xsl:choose>
                </tr>
            </table>

            <xsl:if test="//odpowiedzUdostepnianieDanychODochodach">
                <table>
                    <tr>
                        <td class="label">Rok podatkowy</td>
                        <td colspan='3'><xsl:value-of select="//rokPodatkowy"/></td>
                    </tr>
                </table>
                <!-- osoba 1 -->
                <xsl:if test="//osoba1">
                    <table>
                        <tr>
                            <td colspan='4' align="center" style="font-weight: bold;">DANE OSOBY 1</td>
                        </tr>
                        <tr>
                            <td class="label">PESEL</td>
                            <td colspan='3'><xsl:value-of select="//osoba1/pesel"/></td>
                        </tr>

                        <tr>
                            <td colspan="4">
                                <xsl:for-each select="//osoba1/PIT">
                                    <table>
                                        <tr>
                                            <td class="label">Typ PIT</td>
                                            <td colspan='3'><xsl:value-of select="@typ"/></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Dochód</td>
                                            <td><xsl:value-of select="format-number(dochod, '0,00')"/></td>
                                            <td class="label">Dochód małoletnich dzieci</td>
                                            <td><xsl:value-of select="format-number(dochodDzieci, '0,00')"/></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Składka na ubezpieczenie społeczne</td>
                                            <td><xsl:value-of select="format-number(skladkaUbezpSpol, '0,00')"/></td>
                                            <td class="label">Podatek należny od dochodu</td>
                                            <td><xsl:value-of select="format-number(naleznyPodatek, '0,00')"/></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Dochody osiągnięte za granicą</td>
                                            <td><xsl:value-of select="format-number(dochodyOsiagnieteZaGranica, '0,00')"/></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Czy wspólne</td>
                                            <td>
                                                <xsl:choose>
                                                    <xsl:when test="czyWspolne = 'true'">TAK</xsl:when>
                                                    <xsl:otherwise>NIE</xsl:otherwise>
                                                </xsl:choose>
                                            </td>
                                            <td class="label">Czy przekroczony próg</td>
                                            <td>
                                                <xsl:choose>
                                                    <xsl:when test="@czyPrzekroczonyProg = 'true'">TAK</xsl:when>
                                                    <xsl:otherwise>NIE</xsl:otherwise>
                                                </xsl:choose>
                                            </td>
                                        </tr>
                                    </table>
                                </xsl:for-each>
                            </td>
                        </tr>
                    </table>
                </xsl:if>

                <!-- osoba 2 -->
                <xsl:if test="count(//osoba2) > 0">
                    <table>
                        <tr>
                            <td colspan='4' align="center" style="font-weight: bold;">DANE OSOBY 2</td>
                        </tr>
                        <tr>
                            <td class="label">PESEL</td>
                            <td colspan='3'><xsl:value-of select="//osoba2/pesel"/></td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <xsl:for-each select="//osoba2/PIT">
                                    <table>
                                        <tr>
                                            <td class="label">Typ PIT</td>
                                            <td colspan='3'><xsl:value-of select="@typ"/></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Dochód</td>
                                            <td><xsl:value-of select="format-number(dochod, '0,00')"/></td>
                                            <td class="label">Dochód małoletnich dzieci</td>
                                            <td><xsl:value-of select="format-number(dochodDzieci, '0,00')"/></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Składka na ubezpieczenie społeczne</td>
                                            <td><xsl:value-of select="format-number(skladkaUbezpSpol, '0,00')"/></td>
                                            <td class="label">Podatek należny od dochodu</td>
                                            <td><xsl:value-of select="format-number(naleznyPodatek, '0,00')"/></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Dochody osiągnięte za granicą</td>
                                            <td><xsl:value-of select="format-number(dochodyOsiagnieteZaGranica, '0,00')"/></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Czy wspólne</td>
                                            <td>
                                                <xsl:choose>
                                                    <xsl:when test="czyWspolne = 'true'">TAK</xsl:when>
                                                    <xsl:otherwise>NIE</xsl:otherwise>
                                                </xsl:choose>
                                            </td>
                                            <td class="label">Czy przekroczony próg</td>
                                            <td>
                                                <xsl:choose>
                                                    <xsl:when test="@czyPrzekroczonyProg = 'true'">TAK</xsl:when>
                                                    <xsl:otherwise>NIE</xsl:otherwise>
                                                </xsl:choose>
                                            </td>
                                        </tr>
                                    </table>
                                </xsl:for-each>
                            </td>
                        </tr>
                    </table>
                </xsl:if>

                <!-- kwota zwrotu -->
                <table>
                    <tr>
                        <td class="label">Wartość kwoty zwrotu z tytułu niewykorzystanej ulgi na dzieci</td>
                        <td><xsl:value-of select="format-number(//kwotaZwrotu, '0,00')"/></td>
                    </tr>
                </table>
            </xsl:if>
            <br/>
            <xsl:if test="//DaneOPrzychodachMlodych">
                <!-- osoba podstawowa required -->
                <table style="width: 98%; margin: auto">
                    <tr>
                        <td colspan='4' align="center" style="font-weight: bold;">DANE DOTYCZĄCE PRZYCHODÓW ZWOLNIONYCH NA PODSTAWIE ART. 21 UST. 1
                            PKT 148 USTAWY O PIT OSOBY PODSTAWOWEJ WSKAZANEJ W ZAPYTANIU</td>
                    </tr>
                    <tr>
                        <td>
                            <xsl:call-template name="przychodMlodych">
                                <xsl:with-param name="osobaPM" select="//DaneOPrzychodachMlodych/OsobaPodstawowa" />
                            </xsl:call-template>
                        </td>
                    </tr>
                </table>
                <xsl:if test="//DaneOPrzychodachMlodych/OsobaDodatkowa">
                    <br/>
                    <table style="width: 98%; margin: auto">
                        <tr>
                            <td colspan='4' align="center" style="font-weight: bold;">DANE DOTYCZĄCE PRZYCHODÓW ZWOLNIONYCH NA PODSTAWIE ART. 21 UST. 1
                                PKT 148 USTAWY O PIT OSOBY DODATKOWEJ WSKAZANEJ W ZAPYTANIU</td>
                        </tr>
                        <tr>
                            <td>
                                <xsl:call-template name="przychodMlodych">
                                    <xsl:with-param name="osobaPM" select="//DaneOPrzychodachMlodych/OsobaDodatkowa" />
                                </xsl:call-template>
                            </td>
                        </tr>
                    </table>
                </xsl:if>
            </xsl:if>
        </div>
    </xsl:template>

    <xsl:template name="przychodMlodych">
        <xsl:param name="osobaPM"/>

        <table style="width: 98%; margin: auto">
            <tr>
                <td class="label">PESEL</td>
                <td colspan='3'><xsl:value-of select="$osobaPM/PESEL"/></td>
            </tr>
            <xsl:if test="$osobaPM/SkladkaUbezpSpolPrzychodZwolniony">
                <tr>
                    <td class="label">Składka na ubezp.społeczne (przychód zwolniony od podatku)</td>
                    <td colspan="3"><xsl:value-of select="format-number($osobaPM/SkladkaUbezpSpolPrzychodZwolniony, '0,00')"/></td>
                </tr>
            </xsl:if>
            <tr>
                <td colspan="4">
                    <table style="width:90%; margin: auto;">
                        <tr>
                            <td colspan='4' align="center">Dane z deklaracji PIT i/lub informacji płatników dla podanych danych z zapytania</td>
                        </tr>
                        <tr>
                            <td colspan="4" >
                                <!--DaneZDeklaracjiPodatkowejTyp daneZDeklaracjiPodatkowej-->
                                <table>
                                    <tr>
                                        <td colspan='4' align="center">Dane przychodów zwolnionych na podstawie art. 21 ust. 1 pkt 148 ustawy o
                                            PIT udostępnione na podstawie deklaracji podatkowej PIT-36 lub PIT-37.</td>
                                    </tr>
                                    <tr>
                                        <td class="label">Czy dane pochodzą ze wspólnej deklaracji współmałżonków</td>
                                        <td>
                                            <xsl:choose>
                                                <xsl:when test="$osobaPM/DaneZDeklaracjiPodatkowej/CzyWspolne = 'T'">TAK</xsl:when>
                                                <xsl:otherwise>NIE</xsl:otherwise>
                                            </xsl:choose>
                                        </td>
                                        <td class="label">Kod formularza deklaracji, z której pochodzą dane</td>
                                        <td><xsl:value-of select="$osobaPM/DaneZDeklaracjiPodatkowej/KodFormularza"/></td>
                                    </tr>
                                    <tr>
                                        <td class="label">Przychód zwolniony na podstawie art. 21 ust. 1 pkt 148
                                            ustawy o PIT z umów zlecenia Art. 13 pkt 8</td>
                                        <td><xsl:value-of select="format-number($osobaPM/DaneZDeklaracjiPodatkowej/PrzychodZUmowyZlecenie, '0,00')"/></td>
                                        <td class="label">Przychód zwolniony na podstawie art. 21 ust. 1 pkt 148
                                            ustawy o PIT ze stosunku pracy i stosunków pokrewnych</td>
                                        <td><xsl:value-of select="format-number($osobaPM/DaneZDeklaracjiPodatkowej/PrzychodZeStosunkuPracy, '0,00')"/></td>
                                    </tr>
                                    <tr>
                                        <td class="label">Przychód zwolniony na podstawie art. 21 ust. 1 pkt 148 ustawy o PIT z praktyk</td>
                                        <td><xsl:value-of select="format-number($osobaPM/DaneZDeklaracjiPodatkowej/PrzychodZPraktyk, '0,00')"/></td>
                                        <td/>
                                        <td/>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <xsl:if test="$osobaPM/DaneZInformacjiPlatnikow">
                            <tr>
                                <td colspan="4">
                                    <!--DaneZInformacjiPlatnikowTyp daneZInformacjiPlatnikow-->
                                    <table>
                                        <tr>
                                            <td colspan='4' align="center">Dane przychodów zwolnionych na podstawie art. 21 ust. 1 pkt 148 ustawy o
                                                PIT udostępnione na podstawie informacji PIT-11</td>
                                        </tr>
                                        <tr>
                                            <td class="label">Dochód z umów zlecenia uzyskany w roku podatkowym
                                                od dnia 2019-08-01 do ukończenia 26 roku życia</td>
                                            <td><xsl:value-of select="format-number($osobaPM/DaneZInformacjiPlatnikow/DochodZUmowyZlecenie, '0,00')"/></td>
                                            <td class="label">Dochód ze stosunku pracy, służbowego, spółdzielczego i
                                                pracy nakładczej uzyskany w roku podatkowym od dnia 2019-08-01 do ukończenia 26 roku życia</td>
                                            <td><xsl:value-of select="format-number($osobaPM/DaneZInformacjiPlatnikow/DochodZeStosunkuPracy, '0,00')"/></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Dochód z tytułu praktyk absolwenckich lub staży uczniowskich uzyskany przez
                                                podatnika do ukończenia 26 roku życia</td>
                                            <td><xsl:value-of select="format-number($osobaPM/DaneZInformacjiPlatnikow/DochodZPraktyk, '0,00')"/></td>
                                            <td class="label">Liczba dokumentów PIT-11 na podstawie których udostępniono dane</td>
                                            <td><xsl:value-of select="$osobaPM/DaneZInformacjiPlatnikow/LiczbaDokumentow"/></td>
                                            <td colspan="2"></td>
                                        </tr>
                                        <tr>
                                            <td class="label">Przychody ze stosunku pracy i stosunków pokrewnych oraz z umów zlecenia o
                                                których mowa w art. 21 ust. 1 pkt. 148 ustawy o PIT (do limitu zwolnienia)</td>
                                            <td><xsl:value-of select="format-number($osobaPM/DaneZInformacjiPlatnikow/PrzychodDoLimituZwolnienia, '0,00')"/></td>
                                            <td class="label">Wartość składek na ubezpieczenia społeczne pobrana z deklaracji</td>
                                            <td><xsl:value-of select="format-number($osobaPM/DaneZInformacjiPlatnikow/SkladkaUbezpSpol, '0,00')"/></td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </xsl:if>
                    </table>
                </td>
            </tr>
        </table>
    </xsl:template>
</xsl:stylesheet>

