<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="KodpPobierzInformacjeOPrzychodachZwolnionych">

        <div class="odpowiedz">
            <xsl:apply-templates />
        </div>

    </xsl:template>

    <xsl:template match="statusZlecenia"/>

    <xsl:template match="informacjeODochodzie">
        <hr/>
        <table>
            <caption>INFORMACJE O DOCHODZIE</caption>
            <tr>
                <td class="label">Status odpowiedzi</td>
                <xsl:choose>
                    <xsl:when test="statusOdpowiedzi = 0"><td colspan="2">Zidentyfikowano osoby i udostępniono dane</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 1"><td>Nie znaleziono osób</td><td>Zweryfikuj w  rejestrze  PESEL i sprawdź, czy dane (nr PESEL, Imię pierwsze, Nazwisko) są zgodne - jeśli są zgodne, to należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 2"><td>Niezgodność wspólnego rozliczenia (wspólnie/indywidualnie)</td><td>Komunikat wystąpi, jeśli zapytanie jest na podatnika a zeznanie złożono  wspólnie z małżonkiem bądź, jeśli zapytanie jest jednocześnie na podatnika i małżonka a podatnicy rozliczyli się osobno</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 3"><td>Brak deklaracji podatkowych za podany okres</td><td>Podatnik nie złożył zeznania PIT</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 4"><td>Znaleziono niezatwierdzoną deklarację, dane nie mogą być zwrócone</td><td>Należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 5"><td>Została wydana decyzja wymiarowa, dane nie mogą być zwrócone</td><td>Nie można wydzielić kwoty dochodu - należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 6"><td>Podany w zapytaniu rok nie jest obsługiwany przez usługę</td><td>Dane za rok poprzedni będą dostępne od sierpnia bieżącego roku</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 7"><td>Wskazany w pytaniu podatnik złożył więcej deklaracji tego samego typu w jednym okresie</td><td>Należy wystąpić do właściwego US o udzielenie stosownej informacji</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 8"><td>Limit dochodu został przekroczony, wyślij zapytanie specjalne by uzyskać informacje</td><td>Dane można uzyskać poprzez wykonanie zapytania specjalnego</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = 9"><td>Zidentyfikowano osobę i udostępniono dane </td><td>Dla PIT-36 oraz PIT-37 kwota podatku należnego została obliczona od sumy dochodów obojga podatników, natomiast pozostałe pozycje dotyczą jedynie podatnika, którego dotyczyło zapytanie</td></xsl:when>
                </xsl:choose>
            </tr>
            <xsl:if test="daneODochodach">
                <tr>
                    <td colspan="3">
                        <xsl:apply-templates select="daneODochodach"/>
                    </td>
                </tr>
            </xsl:if>
        </table>
    </xsl:template>

    <xsl:template match="kwotaZwrotu">
        <hr/>
        <table>
            <caption>KWOTA Z TYTUŁU NIEWYKORZYSTANEJ ULGI NA DZIECI</caption>
            <tr>
                <td class="label">Status odpowiedzi</td>
                <xsl:choose>
                    <xsl:when test="statusOdpowiedzi = '0A'"><td colspan="2">Udostępniono dane</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '2A'"><td colspan="2">Niezgodność sposobu rozliczenia (wspólne/indywidualne)</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '3A'"><td colspan="2">Brak deklaracji PIT-36 / PIT-37 za podany okres lub w odnalezionych dokumentach nie została wypełniona pozycja dotycząca przysługującej kwoty różnicy</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '4A'"><td colspan="2">Znaleziono niezatwierdzoną deklarację PIT-36/PIT-37, dane nie mogą być zwrócone</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '5A'"><td colspan="2">Została wydana decyzja wymiarowa do deklaracji PIT-36/PIT-37, dane nie mogą zostać zwrócone</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '6A'"><td colspan="2">Podany w zapytaniu rok nie jest obsługiwany przez usługę</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '7A'"><td colspan="2">Wskazany/i w pytaniu podatnik/cy złożył/li więcej deklaracji tego samego typu w jednym okresie</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '9A'"><td colspan="2">Zidentyfikowano osobę i udostępniono dane (przysługująca kwota różnicy tzw. kwota zwrotu z tytułu niewykorzystanej ulgi na dzieci dotyczy obojga rodziców)</td></xsl:when>
                </xsl:choose>
            </tr>
            <xsl:if test="daneOUldze">
                <tr>
                    <td colspan="2">
                        <xsl:apply-templates select="daneOUldze"/>
                    </td>
                </tr>
            </xsl:if>
        </table>
    </xsl:template>

    <xsl:template match="informacjeOPrzychodachZwolnionych">
        <br/>
        <hr/>
        <table>
            <caption>INFORMACJE O PRZYCHODACH ZWOLNIONYCH</caption>
            <tr>
                <td class="label">Status odpowiedzi</td>
                <xsl:choose>
                    <xsl:when test="statusOdpowiedzi = '0E'"><td colspan="2">Udostępniono dane</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '2E'"><td colspan="2">Niezgodność sposobu rozliczenia</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '3E'"><td colspan="2">Brak dokumentów PIT-36/PIT-37/PIT-11 za podany okres lub brak danych do odpowiedzi na dokumencie</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '4E'"><td colspan="2">Znalezniono niezatwierdzony dokument PIT-36/PIT-37/PIT-11, dane nie mogą być zwrócone</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '5E'"><td colspan="2">Została wydana decyzja wymiarowa, dane nie mogą być zwrócone</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '6E'"><td colspan="2">Podany w zapytaniu rok nie jest obsługiwany przez usługę</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '7E'"><td colspan="2">Wskazany w pytaniu podatnik złożył więcej deklaracji tego samego typu w jednym okresie</td></xsl:when>
                </xsl:choose>
            </tr>
            <tr>
                <td class="label">Rok podatkowy</td>
                <td colspan='3'><xsl:value-of select="rokPodatkowy"/></td>
            </tr>
            <xsl:if test="daneOPrzychodachZwolnionych">
                <tr>
                    <td colspan="2">
                        <xsl:apply-templates select="daneOPrzychodachZwolnionych"/>
                    </td>
                </tr>
            </xsl:if>
        </table>
    </xsl:template>

    <xsl:template match="daneOPrzychodachZwolnionych">
        <table style="width: 95%; align: center; margin: auto;">
            <caption>DANE PODATNIKA</caption>
            <tr>
                <td class="label">PESEL</td>
                <td colspan='3'><xsl:value-of select="osobaPodstawowa/pesel"/></td>
            </tr>
            <tr>
                <td class="label">Składka na ubezp.społeczne (przychód zwolniony od podatku)</td>
                <td><xsl:value-of select="format-number(osobaPodstawowa/skladkaUbezpSpolPrzychodZwolniony, '0,00')"/></td>
            </tr>
            <xsl:if test="osobaPodstawowa/daneZDeklaracjiPodatkowej">
                <tr>
                    <td colspan="2">
                        <xsl:call-template name="daneZDeklaracjiPodatkowej">
                            <xsl:with-param name="deklaracja" select="osobaPodstawowa/daneZDeklaracjiPodatkowej"/>
                        </xsl:call-template>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="osobaPodstawowa/daneZInformacjiPlatnikow">
                <tr>
                    <td colspan="2">
                        <xsl:call-template name="daneZInformacjiPlatnikow">
                            <xsl:with-param name="deklaracja" select="osobaPodstawowa/daneZInformacjiPlatnikow"/>
                        </xsl:call-template>
                    </td>
                </tr>
            </xsl:if>
        </table>
        <xsl:if test="osobaDodatkowa">
            <br/>
            <table style="width: 95%; align: center; margin: auto;">
                <caption>DANE WSPÓŁMAŁŻONKA/DZIECKA</caption>
                <tr>
                    <td class="label">PESEL</td>
                    <td colspan='3'><xsl:value-of select="osobaDodatkowa/pesel"/></td>
                </tr>
                <tr>
                    <td class="label">Składka na ubezp.społeczne (przychód zwolniony od podatku)</td>
                    <td><xsl:value-of select="format-number(osobaDodatkowa/skladkaUbezpSpolPrzychodZwolniony, '0,00')"/></td>
                </tr>
                <xsl:if test="osobaDodatkowa/daneZDeklaracjiPodatkowej">
                    <tr>
                        <td colspan="2">
                            <xsl:call-template name="daneZDeklaracjiPodatkowej">
                                <xsl:with-param name="deklaracja" select="osobaDodatkowa/daneZDeklaracjiPodatkowej"/>
                            </xsl:call-template>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:if test="osobaDodatkowa/daneZInformacjiPlatnikow">
                    <tr>
                        <td colspan="2">
                            <xsl:call-template name="daneZInformacjiPlatnikow">
                                <xsl:with-param name="deklaracja" select="osobaDodatkowa/daneZInformacjiPlatnikow"/>
                            </xsl:call-template>
                        </td>
                    </tr>
                </xsl:if>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template name="daneZDeklaracjiPodatkowej">
        <xsl:param name="deklaracja"/>
        <br/>
        <table style="width: 80%; align: center; margin: auto;">
            <tr>
                <td rowspan="6" class="label" style="width: 10%">
                    DANE Z DEKLARACJI PODATKOWEJ<br/><br/>
                    Kod formularza: <xsl:value-of select="$deklaracja/kodFormularza"/><br/><br/>
                    Czy wspólne:
                    <xsl:choose>
                        <xsl:when test="$deklaracja/czyWspolne = 'T'">TAK</xsl:when>
                        <xsl:when test="$deklaracja/czyWspolne = 'N'">NIE</xsl:when>
                    </xsl:choose>
                </td>
            </tr>
            <tr>
                <td class="label">Przychód zwolniony na podstawie art. 21 ust. 1 pkt 148 ustawy o PIT z praktyk</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/przychodZPraktyk, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Przychód zwolniony na podstawie art. 21 ust. 1 pkt 148, 152-154 ustawy o PIT ze stosunku pracy i stosunków pokrewnych</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/przychodZwolnionyZeStosunkuSluzbowego, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Przychód zwolniony na podstawie art. 21 ust. 1 pkt 148, 152-154 ustawy o PIT z umów zlecenia Art. 13 pkt 8</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/przychodZwolnionyZUmowZlecenia, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Przychód zwolniony na podstawie art. 21 ust. 1 pkt 148 i 152-154 ustawy o PIT z zasiłku macierzyńskiego</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/przychodZwolnionyZZasilkuMacierzynskiego, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Przychód zwolniony na podstawie art. 21 ust. 1 pkt 152-154 ustawy o PIT z pozarolniczej działalności gospodarczej</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/przychodZwolnionyZPozarolniczejDzialalnosciGospodarczej, '0,00')"/></td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template name="daneZInformacjiPlatnikow">
        <xsl:param name="deklaracja"/>
        <br/>
        <table style="width: 80%; align: center; margin: auto;">
            <tr>
                <td rowspan="13" class="label" style="width: 10%">
                    DANE Z DEKLARACJI PŁATNIKÓW
                </td>
            </tr>
            <tr>
                <td class="label">Liczba dokumentów PIT-11, PIT-11A i PIT-40A na podstawie których udostępniono dane</td>
                <td><xsl:value-of select="$deklaracja/LiczbaDokumentow"/></td>
            </tr>
            <tr>
                <td class="label">Dochód ze stosunku pracy, służbowego, spółdzielczego i pracy nakładczej uzyskany w roku podatkowym do ukończenia 26 roku życia</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/dochodMlodychZeStosunkuPracy, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Dochód z umów zlecenia uzyskany w roku podatkowym do ukończenia 26 roku życia</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/dochodMlodychZUmowZlecenia, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Dochód z tytułu praktyk absolwenckich lub staży uczniowskich uzyskany przez podatnika do ukończenia 26 roku życia</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/dochodMlodychZPraktyk, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Dochód z tytułu zasiłku macierzyńskiego otrzymane przez podatników do ukończenia 26 roku życia</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/dochodMlodychZZasilkuMacierzynskiego, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Przychody ze stosunku pracy i stosunków pokrewnych oraz z umów zlecenia, praktyk absolwenckich lub staży uczniowskich oraz zasiłku macierzyńskiego, o których mowa w art. 21 ust. 1 pkt. 148 ustawy (do limitu zwolnienia)</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/przychodMlodychDoLimituZwolnienia, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Dochód ze stosunku: pracy, służbowego, spółdzielczego i z pracy nakładczej, wypłacone przez zakład pracy otrzymane przez podatników od ukończenia wieku emerytalnego</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/dochodZeStosunkuPracyOdUkonczeniaWiekuEmerytalnego, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Dochód z tytułu umowy zlecenia otrzymane przez podatników od ukończenia wieku emerytalnego</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/dochodZUmowZleceniaOdUkonczeniaWiekuEmerytalnego, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Dochód z tytułu zasiłku macierzyńskiego otrzymane przez podatników od ukończenia wieku emerytalnego</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/dochodzZasilkuMacierzynskiegoOdUkonczeniaWiekuEmerytalnego, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Przychody z zasiłków macierzyńskich, o których mowa w art. 21 ust. 1 pkt 148 i 152-154 ustawy</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/przychodyZZasilkowMacierzynskichZOrganowEmerytalnorentowych, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Przychody ze stosunku pracy i stosunków pokrewnych oraz z umów zlecenia oraz zasiłku macierzyńskiego, o których mowa w art. 21 ust. 1 pkt 152-154 ustawy</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/przychodyZwolnione, '0,00')"/></td>
            </tr>
            <tr>
                <td class="label">Składki na ubezpieczenia społeczne, o których mowa w przepisach ustawy o PIT, których podstawę wymiaru stanowi przychód zwolniony na podstawie art. 21 ust. 1 pkt 148, 152-154 ustawy</td>
                <td class="opcjonalne"><xsl:value-of select="format-number($deklaracja/skladkaUbezpSpol, '0,00')"/></td>
            </tr>
        </table>
    </xsl:template>
</xsl:stylesheet>
