<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/" name="KodpPobierzKwotePodatkuNaleznegoDuchownych">

        <div class="odpowiedz">
            <xsl:apply-templates />
        </div>

    </xsl:template>

    <xsl:template match="statusZlecenia"/>

    <xsl:template match="kwotaPodatkuNaleznegoDuchownych">
        <hr/>
        <table>
            <caption>INFORMACJE O PODATKU NALEŻNYM W ZAKRESIE RYCZAŁTU OD PRZYCHODÓW DUCHOWNYCH NALICZONYM DECYZJĄ</caption>
            <tr>
                <td class="label">Status odpowiedzi</td>
                <xsl:choose>
                    <xsl:when test="statusOdpowiedzi = '0D'"><td>Udostępniono dane</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '3D'"><td>Brak danych w zakresie zapytania</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '4D'"><td>Znaleziono niezatwierdzony dokument, dane nie mogą zostać zwrócone</td></xsl:when>
                    <xsl:when test="statusOdpowiedzi = '6D'"><td>Podany w zapytaniu rok nie jest obsługiwany przez usługę</td></xsl:when>
                </xsl:choose>
            </tr>
            <tr>
                <td class="label">Kwota podatku należnego</td>
                <td class="opcjonalne"><xsl:value-of select="format-number(kwotaPodatkuNaleznego, '0,00')"/></td>
            </tr>
        </table>
    </xsl:template>

</xsl:stylesheet>